/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.builtin;

import jakarta.validation.Validator;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class OptionalValueExtractorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)OptionalValueExtractorTest.webArchiveBuilder().withTestClass(OptionalValueExtractorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="d")
    public void optionalValueExtractor() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new OptionalHolder(Optional.of("valid")), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = validator.validate((Object)new OptionalHolder(Optional.of("")), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("optional"));
        violations = validator.validate((Object)new OptionalHolder(Optional.empty()), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("optional"), ConstraintViolationAssert.violationOf(NotNull.class).withProperty("optional"));
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="e")
    public void optionalIntValueExtractor() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new OptionalIntHolder(OptionalInt.of(10)), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = validator.validate((Object)new OptionalIntHolder(OptionalInt.of(3)), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withProperty("optionalInt"));
        violations = validator.validate((Object)new OptionalIntHolder(OptionalInt.empty()), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("optionalInt"));
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="e")
    public void optionalLongValueExtractor() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new OptionalLongHolder(OptionalLong.of(10L)), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = validator.validate((Object)new OptionalLongHolder(OptionalLong.of(3L)), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withProperty("optionalLong"));
        violations = validator.validate((Object)new OptionalLongHolder(OptionalLong.empty()), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("optionalLong"));
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="e")
    public void optionalDoubleValueExtractor() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new OptionalDoubleHolder(OptionalDouble.of(10.0)), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = validator.validate((Object)new OptionalDoubleHolder(OptionalDouble.of(3.0)), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(DecimalMin.class).withProperty("optionalDouble"));
        violations = validator.validate((Object)new OptionalDoubleHolder(OptionalDouble.empty()), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("optionalDouble"));
    }

    private static class OptionalHolder {
        private final Optional<@NotNull @NotBlank String> optional;

        private OptionalHolder(Optional<String> optional) {
            this.optional = optional;
        }
    }

    private static class OptionalIntHolder {
        @NotNull
        @Min(value=5L)
        private final @NotNull @Min(value=5L) OptionalInt optionalInt;

        private OptionalIntHolder(OptionalInt optionalInt) {
            this.optionalInt = optionalInt;
        }
    }

    private static class OptionalLongHolder {
        @NotNull
        @Min(value=5L)
        private final @NotNull @Min(value=5L) OptionalLong optionalLong;

        private OptionalLongHolder(OptionalLong optionalLong) {
            this.optionalLong = optionalLong;
        }
    }

    private static class OptionalDoubleHolder {
        @NotNull
        @DecimalMin(value="5")
        private final @NotNull @DecimalMin(value="5") OptionalDouble optionalDouble;

        private OptionalDoubleHolder(OptionalDouble optionalDouble) {
            this.optionalDouble = optionalDouble;
        }
    }
}

