/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.glsp.graph.gson.EnumTypeAdapter;
import org.eclipse.glsp.graph.gson.GraphGsonConfigurator;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.diagram.ServerConfigurationContribution;
import org.eclipse.glsp.server.gson.ActionTypeAdapter;
import org.eclipse.glsp.server.gson.ServerGsonConfigurator;

public class DefaultServerGsonConfigurator
implements ServerGsonConfigurator {
    protected ActionRegistry actionRegistry;
    protected GraphGsonConfigurator graphGsonConfigurator;

    @Inject
    public DefaultServerGsonConfigurator(Injector serverInjector, @Named(value="Diagram_Modules") Map<String, Module> diagramModules, ActionRegistry actionRegistry) {
        this.actionRegistry = actionRegistry;
        this.graphGsonConfigurator = this.createGraphGsonConfigurator();
        diagramModules.values().stream().map(module -> (ServerConfigurationContribution)serverInjector.createChildInjector(new Module[]{module}).getInstance(ServerConfigurationContribution.class)).forEach(contribution -> {
            contribution.configure(actionRegistry);
            contribution.configure(this.graphGsonConfigurator);
        });
    }

    protected TypeAdapterFactory getActionTypeAdapterFactory() {
        return new ActionTypeAdapter.Factory(this.actionRegistry.getAllAsMap());
    }

    protected GraphGsonConfigurator createGraphGsonConfigurator() {
        return new GraphGsonConfigurator();
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapterFactory(this.getActionTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory());
        return this.graphGsonConfigurator.configureGsonBuilder(gsonBuilder);
    }
}

