/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.server.features.core.model.ModelSourceLoader;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.gson.GraphGsonConfigurationFactory;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;

public class JsonFileGModelLoader
implements ModelSourceLoader {
    private static Logger LOG = Logger.getLogger(JsonFileGModelLoader.class);
    private static String EMPTY_ROOT_ID = "glsp-graph";
    @Inject
    private GraphGsonConfigurationFactory gsonConfiguratior;
    @Inject
    protected GModelState modelState;

    @Override
    public void loadSourceModel(RequestModelAction action) {
        File file = this.convertToFile(this.modelState);
        this.loadSourceModel(file, this.modelState).ifPresent(root -> {
            this.modelState.setRoot(root);
            ((GModelRoot)this.modelState.getRoot()).setRevision(-1);
        });
    }

    protected File convertToFile(GModelState modelState) {
        return GLSPServerException.getOrThrow(ClientOptionsUtil.getSourceUriAsFile(modelState.getClientOptions()), "Invalid file URI:" + ClientOptionsUtil.getSourceUri(modelState.getClientOptions()));
    }

    protected Optional<GModelRoot> loadSourceModel(File file, GModelState modelState) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                Gson gson = this.gsonConfiguratior.configureGson().create();
                GGraph root = (GGraph)gson.fromJson((Reader)reader, GGraph.class);
                if (root == null) {
                    boolean isEmpty;
                    boolean bl = isEmpty = file.length() == 0L;
                    if (isEmpty) {
                        return Optional.of(this.createNewEmptyRoot(modelState));
                    }
                    throw new IOException("Could not deserialize file contents of: " + file.toURI().toString());
                }
                return Optional.ofNullable(root);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new GLSPServerException("Could not load model from file: " + file.toURI().toString(), e);
        }
    }

    protected GModelRoot createNewEmptyRoot(GModelState modelState) {
        GGraph root = GraphFactory.eINSTANCE.createGGraph();
        root.setId(EMPTY_ROOT_ID);
        root.setType("graph");
        return root;
    }
}

