/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.actions.SetDirtyStateAction;
import org.eclipse.glsp.server.features.modelsourcewatcher.ModelSourceWatcher;
import org.eclipse.glsp.server.gson.GraphGsonConfigurationFactory;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;

public class SaveModelActionHandler
extends AbstractActionHandler<SaveModelAction> {
    private static final Logger LOG = Logger.getLogger(SaveModelActionHandler.class);
    @Inject
    protected GraphGsonConfigurationFactory gsonConfigurator;
    @Inject
    protected Optional<ModelSourceWatcher> modelSourceWatcher;
    @Inject
    protected GModelState modelState;

    @Override
    public List<Action> executeAction(SaveModelAction action) {
        this.modelSourceWatcher.ifPresent(watcher -> watcher.pauseWatching());
        try {
            this.saveModelState(action);
        }
        catch (Throwable throwable) {
            this.modelSourceWatcher.ifPresent(watcher -> watcher.continueWatching());
            throw throwable;
        }
        this.modelSourceWatcher.ifPresent(watcher -> watcher.continueWatching());
        return this.listOf(new SetDirtyStateAction(this.modelState.isDirty(), "save"));
    }

    protected void saveModelState(SaveModelAction action) {
        File file = this.convertToFile(action);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                Gson gson = this.gsonConfigurator.configureGson().setPrettyPrinting().create();
                gson.toJson(this.modelState.getRoot(), GGraph.class, (Appendable)writer);
                if (this.saveIsDone(action)) {
                    this.modelState.saveIsDone();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new GLSPServerException("An error occured during save process.", e);
        }
    }

    protected boolean saveIsDone(SaveModelAction action) {
        String sourceUri = ClientOptionsUtil.adaptUri(this.modelState.getClientOptions().get("sourceUri"));
        return action.getFileUri().map(uri -> ClientOptionsUtil.adaptUri(uri).equals(sourceUri)).orElse(true);
    }

    protected File convertToFile(SaveModelAction action) {
        if (action.getFileUri().isPresent()) {
            return ClientOptionsUtil.getAsFile(action.getFileUri().get());
        }
        return GLSPServerException.getOrThrow(ClientOptionsUtil.getSourceUriAsFile(this.modelState.getClientOptions()), "Invalid file URI:" + ClientOptionsUtil.getSourceUri(this.modelState.getClientOptions()));
    }
}

