/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.glsp.ide.editor.internal.utils.SystemUtils;
import org.eclipse.glsp.ide.editor.ui.BrowserFunctionInstaller;
import org.eclipse.glsp.ide.editor.utils.SWTUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Control;

public class BrowserFocusControlInstaller
implements BrowserFunctionInstaller {
    private static final String FUNCTION_NAME = "mouseDownHappened";
    private static final String FUNCTION_INSTALLER = "document.onmousedown = function(e) {if (!e) {e = window.event;} if (e) {mouseDownHappened();}}";

    @Override
    public Optional<BrowserFunction> install(Browser browser) {
        return SWTUtil.isChromium(browser) ? this.doInstall(browser) : Optional.empty();
    }

    protected Optional<BrowserFunction> doInstall(final Browser browser) {
        BrowserFunction browserFunction = new BrowserFunction(browser, FUNCTION_NAME){

            public Object function(Object[] arguments) {
                browser.getDisplay().asyncExec(() -> BrowserFocusControlInstaller.this.setFocus(browser));
                return null;
            }
        };
        browser.execute(FUNCTION_INSTALLER);
        return Optional.of(browserFunction);
    }

    protected void setFocus(Browser browser) {
        if (browser.isDisposed()) {
            return;
        }
        if (SystemUtils.isWindows()) {
            browser.forceFocus();
        } else {
            Control focusControl = browser.getDisplay().getFocusControl();
            if (Objects.equals(focusControl, browser)) {
                return;
            }
            browser.setFocus();
            focusControl = browser.getDisplay().getFocusControl();
            if (focusControl != browser) {
                browser.forceFocus();
            }
        }
    }
}

