/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.utils;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class UIUtil {
    private static final Logger LOGGER = Logger.getLogger(UIUtil.class);

    private UIUtil() {
    }

    public static Optional<IWorkbench> getWorkbench() {
        return Optional.ofNullable(PlatformUI.getWorkbench());
    }

    public static Optional<IWorkbenchWindow> getActiveWorkbenchWindow() {
        return UIUtil.getWorkbench().map(IWorkbench::getActiveWorkbenchWindow);
    }

    public static Optional<IWorkbenchPage> getActivePage() {
        return UIUtil.getActiveWorkbenchWindow().map(IWorkbenchWindow::getActivePage);
    }

    public static Optional<Display> findDisplay() {
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            return Optional.of(currentDisplay);
        }
        Optional<Display> workbenchDisplay = UIUtil.getWorkbench().map(IWorkbench::getDisplay);
        return workbenchDisplay.isPresent() ? workbenchDisplay : Optional.ofNullable(Display.getDefault());
    }

    public static void asyncExec(Runnable runnable) {
        Optional<Display> display = UIUtil.findDisplay();
        if (display.isPresent()) {
            display.get().asyncExec(runnable);
        } else {
            LOGGER.warn((Object)"Could not detect display, try running on current thread.");
            runnable.run();
        }
    }

    public static Optional<Shell> findShell(String clientId) {
        return GLSPIdeEditorPlugin.getDefault().getGLSPEditorRegistry().getGLSPEditor(clientId).map(editor -> editor.getEditorSite().getShell()).or(UIUtil::findShell);
    }

    private static Optional<Shell> findShell() {
        return UIUtil.findDisplay().flatMap(display -> Optional.ofNullable(display.getActiveShell()));
    }
}

