/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractNioInputBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNioInputBuffer
extends AbstractNioInputBuffer<NioChannel> {
    private static final Log log = LogFactory.getLog(InternalNioInputBuffer.class);
    private NioChannel socket;
    private NioSelectorPool pool;

    public InternalNioInputBuffer(Request request, int headerBufferSize) {
        super(request, headerBufferSize);
        this.inputStreamInputBuffer = new SocketInputBuffer();
    }

    @Override
    protected final Log getLog() {
        return log;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.socket = null;
    }

    @Override
    protected void init(SocketWrapper<NioChannel> socketWrapper, AbstractEndpoint<NioChannel> endpoint) throws IOException {
        this.socket = socketWrapper.getSocket();
        if (this.socket == null) {
            throw new IOException(sm.getString("iib.socketClosed"));
        }
        this.socketReadBufferSize = this.socket.getBufHandler().getReadBuffer().capacity();
        int bufLength = this.headerBufferSize + this.socketReadBufferSize;
        if (this.buf == null || this.buf.length < bufLength) {
            this.buf = new byte[bufLength];
        }
        this.pool = ((NioEndpoint)endpoint).getSelectorPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean fill(boolean block) throws IOException, EOFException {
        if (this.parsingHeader) {
            if (this.lastValid > this.headerBufferSize) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
        } else {
            this.lastValid = this.pos = this.end;
        }
        int nRead = 0;
        ByteBuffer readBuffer = this.socket.getBufHandler().getReadBuffer();
        readBuffer.clear();
        if (block) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment();
                if (att == null) {
                    throw new IOException("Key must be cancelled.");
                }
                nRead = this.pool.read(readBuffer, this.socket, selector, this.socket.getIOChannel().socket().getSoTimeout());
            }
            catch (EOFException eof) {
                nRead = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            nRead = this.socket.read(readBuffer);
        }
        if (nRead > 0) {
            readBuffer.flip();
            readBuffer.limit(nRead);
            this.expand(nRead + this.pos);
            readBuffer.get(this.buf, this.pos, nRead);
            this.lastValid = this.pos + nRead;
        } else if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return nRead > 0;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNioInputBuffer.this.pos >= InternalNioInputBuffer.this.lastValid && !InternalNioInputBuffer.this.fill(true)) {
                return -1;
            }
            int length = InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
            chunk.setBytes(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, length);
            InternalNioInputBuffer.this.pos = InternalNioInputBuffer.this.lastValid;
            return length;
        }
    }
}

