/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Method;
import org.apache.catalina.Executor;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.Attributes;

public class ConnectorCreateRule
extends Rule {
    private static final Log log = LogFactory.getLog(ConnectorCreateRule.class);
    protected static final StringManager sm = StringManager.getManager(ConnectorCreateRule.class);

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String sslImplementationName;
        Service svc = (Service)this.digester.peek();
        Executor ex = null;
        if (attributes.getValue("executor") != null) {
            ex = svc.getExecutor(attributes.getValue("executor"));
        }
        Connector con = new Connector(attributes.getValue("protocol"));
        if (ex != null) {
            ConnectorCreateRule.setExecutor(con, ex);
        }
        if ((sslImplementationName = attributes.getValue("sslImplementationName")) != null) {
            ConnectorCreateRule.setSSLImplementationName(con, sslImplementationName);
        }
        this.digester.push((Object)con);
    }

    private static void setExecutor(Connector con, Executor ex) throws Exception {
        Method m = IntrospectionUtils.findMethod(con.getProtocolHandler().getClass(), (String)"setExecutor", (Class[])new Class[]{java.util.concurrent.Executor.class});
        if (m != null) {
            m.invoke((Object)con.getProtocolHandler(), ex);
        } else {
            log.warn((Object)sm.getString("connector.noSetExecutor", new Object[]{con}));
        }
    }

    private static void setSSLImplementationName(Connector con, String sslImplementationName) throws Exception {
        Method m = IntrospectionUtils.findMethod(con.getProtocolHandler().getClass(), (String)"setSslImplementationName", (Class[])new Class[]{String.class});
        if (m != null) {
            m.invoke((Object)con.getProtocolHandler(), sslImplementationName);
        } else {
            log.warn((Object)sm.getString("connector.noSetSSLImplementationName", new Object[]{con}));
        }
    }

    public void end(String namespace, String name) throws Exception {
        this.digester.pop();
    }
}

