/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog(CachedIntrospectionResults.class);
    static final Set<ClassLoader> acceptedClassLoaders = Collections.synchronizedSet(new HashSet());
    static final Map<Class, Object> classCache = Collections.synchronizedMap(new WeakHashMap());
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;

    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            acceptedClassLoaders.add(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClassLoader(ClassLoader classLoader) {
        Iterator<Object> it;
        if (classLoader == null) {
            return;
        }
        Object object = classCache;
        synchronized (object) {
            it = classCache.keySet().iterator();
            while (it.hasNext()) {
                Class beanClass = it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
                it.remove();
            }
        }
        object = acceptedClassLoaders;
        synchronized (object) {
            it = acceptedClassLoaders.iterator();
            while (it.hasNext()) {
                ClassLoader registeredLoader = (ClassLoader)it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(registeredLoader, classLoader)) continue;
                it.remove();
            }
        }
    }

    static CachedIntrospectionResults forClass(Class beanClass) throws BeansException {
        CachedIntrospectionResults results;
        Object value = classCache.get(beanClass);
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            results = (CachedIntrospectionResults)ref.get();
        } else {
            results = (CachedIntrospectionResults)value;
        }
        if (results == null) {
            results = new CachedIntrospectionResults(beanClass);
            if (ClassUtils.isCacheSafe((Class)beanClass, (ClassLoader)CachedIntrospectionResults.class.getClassLoader()) || CachedIntrospectionResults.isClassLoaderAccepted(beanClass.getClassLoader()) || !ClassUtils.isPresent((String)(String.valueOf(beanClass.getName()) + "BeanInfo"), (ClassLoader)beanClass.getClassLoader())) {
                classCache.put(beanClass, results);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not strongly caching class [" + beanClass.getName() + "] because it is not cache-safe"));
                }
                classCache.put(beanClass, new WeakReference<CachedIntrospectionResults>(results));
            }
        }
        return results;
    }

    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        ClassLoader[] acceptedLoaderArray;
        ClassLoader[] classLoaderArray = acceptedLoaderArray = acceptedClassLoaders.toArray(new ClassLoader[acceptedClassLoaders.size()]);
        int n = acceptedLoaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader registeredLoader = classLoaderArray[n2];
            if (CachedIntrospectionResults.isUnderneathClassLoader(classLoader, registeredLoader)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader candidate, ClassLoader parent) {
        if (candidate == null) {
            return false;
        }
        if (candidate == parent) {
            return true;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class beanClass) throws BeansException {
        try {
            PropertyDescriptor[] pds;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Getting BeanInfo for class [" + beanClass.getName() + "]"));
            }
            this.beanInfo = Introspector.getBeanInfo(beanClass);
            Class classToFlush = beanClass;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Caching PropertyDescriptors for class [" + beanClass.getName() + "]"));
            }
            this.propertyDescriptorCache = new HashMap<String, PropertyDescriptor>();
            PropertyDescriptor[] propertyDescriptorArray = pds = this.beanInfo.getPropertyDescriptors();
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found bean property '" + pd.getName() + "'" + (pd.getPropertyType() != null ? " of type [" + pd.getPropertyType().getName() + "]" : "") + (pd.getPropertyEditorClass() != null ? "; editor [" + pd.getPropertyEditorClass().getName() + "]" : "")));
                }
                pd = new GenericTypeAwarePropertyDescriptor(beanClass, pd.getName(), pd.getReadMethod(), pd.getWriteMethod(), pd.getPropertyEditorClass());
                this.propertyDescriptorCache.put(pd.getName(), pd);
                ++n2;
            }
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Cannot get BeanInfo for object of class [" + beanClass.getName() + "]", ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && StringUtils.hasLength((String)name) && (pd = this.propertyDescriptorCache.get(String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1))) == null) {
            pd = this.propertyDescriptorCache.get(String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
        }
        return pd;
    }

    PropertyDescriptor[] getPropertyDescriptors() {
        Collection<PropertyDescriptor> descriptorCollection = this.propertyDescriptorCache.values();
        return descriptorCollection.toArray(new PropertyDescriptor[descriptorCollection.size()]);
    }
}

