/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.parser.manifest.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;
import org.eclipse.virgo.util.parser.manifest.internal.ManifestVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardVisitor
implements ManifestVisitor,
ManifestContents {
    private String version;
    private Map<String, String> mainAttributes = new HashMap<String, String>();
    private List<String> otherSectionNames = new ArrayList<String>();
    private Map<String, Map<String, String>> otherSectionAttributes = new HashMap<String, Map<String, String>>();
    private Map<String, String> currentAttributes;
    protected boolean terminateAfterMainSection = false;

    @Override
    public void visitManifestVersion(String version) {
        this.mainAttributes.put("Manifest-Version", version);
        this.version = version;
    }

    @Override
    public void visitHeader(String name, String value) {
        if (this.currentAttributes == this.mainAttributes && "Manifest-Version".equals(name)) {
            this.version = value;
        }
        this.currentAttributes.put(name, value);
    }

    @Override
    public List<String> getSectionNames() {
        return this.otherSectionNames;
    }

    @Override
    public boolean visitSection(boolean isMain, String name) {
        this.currentAttributes = new HashMap<String, String>();
        if (isMain) {
            this.mainAttributes = this.currentAttributes;
        } else {
            if (this.terminateAfterMainSection) {
                return false;
            }
            this.otherSectionNames.add(name);
            this.otherSectionAttributes.put(name, this.currentAttributes);
        }
        return true;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, String> getMainAttributes() {
        return this.mainAttributes;
    }

    @Override
    public Map<String, String> getAttributesForSection(String sectionName) {
        return this.otherSectionAttributes.get(sectionName);
    }

    @Override
    public void setTerminateAfterMainSection(boolean b) {
        this.terminateAfterMainSection = b;
    }

    @Override
    public ManifestContents getManifestContents() {
        return this;
    }
}

