/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.extender;

import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebApplicationStartFailedException;
import org.eclipse.gemini.web.core.WebContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.BundleTrackerCustomizer;

final class WebContainerBundleCustomizer
implements BundleTrackerCustomizer {
    private final WebContainer container;
    private final Bundle extenderBundle;

    public WebContainerBundleCustomizer(WebContainer container, Bundle extenderBundle) {
        this.container = container;
        this.extenderBundle = extenderBundle;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        WebApplication handle = null;
        if (this.container.isWebBundle(bundle)) {
            try {
                WebApplication webApplication;
                handle = webApplication = this.container.createWebApplication(bundle, this.extenderBundle);
                webApplication.start();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
            catch (WebApplicationStartFailedException webApplicationStartFailedException) {}
        }
        return handle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (this.container.isWebBundle(bundle)) {
            ((WebApplication)object).stop();
        }
    }
}

