/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcArrayLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcEnumLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncBlockAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcRealLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcStructLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.functions.PlcPlainFuncDescription;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentBlock;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcFuncApplStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcReturnStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcSelectionStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class ModelTextGenerator {
    private final PlcTarget target;

    public ModelTextGenerator(PlcTarget target) {
        this.target = target;
    }

    public String toString(PlcExpression expr) {
        return this.toString(expr, FuncApplPreference.PREFER_INFIX);
    }

    public String toString(PlcExpression expr, FuncApplPreference funcApplPreference) {
        StringBuilder textBuilder = new StringBuilder();
        this.toText(expr, textBuilder, funcApplPreference);
        return textBuilder.toString();
    }

    private void toText(PlcExpression expr, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        this.toText(expr, textBuilder, PlcBasicFuncDescription.ExprBinding.NO_PRIORITY, false, false, funcApplPreference);
    }

    private void toText(PlcExpression expr, StringBuilder textBuilder, PlcBasicFuncDescription.ExprBinding parentBinding, boolean atParentLeft, boolean atParentRight, FuncApplPreference funcApplPreference) {
        if (expr instanceof PlcBoolLiteral) {
            PlcBoolLiteral boolLit = (PlcBoolLiteral)expr;
            this.toText(boolLit, textBuilder);
        } else if (expr instanceof PlcIntLiteral) {
            PlcIntLiteral intLit = (PlcIntLiteral)expr;
            this.toText(intLit, textBuilder);
        } else if (expr instanceof PlcRealLiteral) {
            PlcRealLiteral realLit = (PlcRealLiteral)expr;
            this.toText(realLit, textBuilder);
        } else if (expr instanceof PlcEnumLiteral) {
            PlcEnumLiteral enumLit = (PlcEnumLiteral)expr;
            this.toText(enumLit, textBuilder);
        } else if (expr instanceof PlcArrayLiteral) {
            PlcArrayLiteral arrayLit = (PlcArrayLiteral)expr;
            this.toText(arrayLit, textBuilder, funcApplPreference);
        } else if (expr instanceof PlcStructLiteral) {
            PlcStructLiteral structLit = (PlcStructLiteral)expr;
            this.toText(structLit, textBuilder, funcApplPreference);
        } else if (expr instanceof PlcFuncAppl) {
            PlcFuncAppl funcAppl = (PlcFuncAppl)expr;
            this.toText(funcAppl, textBuilder, parentBinding, atParentLeft, atParentRight, funcApplPreference);
        } else if (expr instanceof PlcVarExpression) {
            PlcVarExpression varExpr = (PlcVarExpression)expr;
            this.toText(varExpr, textBuilder, funcApplPreference);
        } else {
            throw new AssertionError((Object)("Unexpected PLC expression \"" + String.valueOf(expr) + "\" found."));
        }
    }

    public String literalToString(PlcExpression expr) {
        String value;
        if (PlcElementaryType.isIntType(expr.type)) {
            Integer value2 = this.tryGetIntValue(expr);
            if (value2 != null) {
                return Integer.toString(value2);
            }
        } else if (PlcElementaryType.isRealType(expr.type) && (value = this.tryGetRealValue(expr)) != null) {
            return value;
        }
        return this.toString(expr);
    }

    private Integer tryGetIntValue(PlcExpression expr) {
        Assert.check((boolean)PlcElementaryType.isIntType(expr.type));
        if (expr instanceof PlcIntLiteral) {
            PlcIntLiteral intLit = (PlcIntLiteral)expr;
            return intLit.value;
        }
        if (expr instanceof PlcFuncAppl) {
            PlcFuncAppl fnAppl = (PlcFuncAppl)expr;
            PlcBasicFuncDescription funcDesc = fnAppl.function;
            if (funcDesc.operation == PlcFuncOperation.NEGATE_OP) {
                Integer v = this.tryGetIntValue(fnAppl.arguments.get((Object)funcDesc.parameters[0].name).value);
                return v == null ? null : Integer.valueOf(-v.intValue());
            }
            if (funcDesc.operation == PlcFuncOperation.SUBTRACT_OP) {
                Integer left = this.tryGetIntValue(fnAppl.arguments.get((Object)funcDesc.parameters[0].name).value);
                Integer right = this.tryGetIntValue(fnAppl.arguments.get((Object)funcDesc.parameters[1].name).value);
                if (left != null && right != null) {
                    return left - right;
                }
            }
        }
        return null;
    }

    private String tryGetRealValue(PlcExpression expr) {
        Assert.check((boolean)PlcElementaryType.isRealType(expr.type));
        if (expr instanceof PlcRealLiteral) {
            PlcRealLiteral realLit = (PlcRealLiteral)expr;
            return realLit.value;
        }
        if (expr instanceof PlcFuncAppl) {
            PlcFuncAppl fnAppl = (PlcFuncAppl)expr;
            PlcBasicFuncDescription funcDesc = fnAppl.function;
            if (funcDesc.operation == PlcFuncOperation.NEGATE_OP) {
                Object v = this.tryGetRealValue(fnAppl.arguments.get((Object)funcDesc.parameters[0].name).value);
                if (v != null) {
                    v = ((String)v).startsWith("-") ? ((String)v).substring(1) : "-" + (String)v;
                }
                return v;
            }
        }
        return null;
    }

    private void toText(PlcBoolLiteral boolLit, StringBuilder textBuilder) {
        textBuilder.append(boolLit.value ? "TRUE" : "FALSE");
    }

    private void toText(PlcIntLiteral intLit, StringBuilder textBuilder) {
        textBuilder.append(String.valueOf(intLit.value));
    }

    private void toText(PlcRealLiteral realLit, StringBuilder textBuilder) {
        Object rslt = realLit.value;
        int idx = ((String)rslt).indexOf(46);
        if (idx == -1) {
            idx = ((String)rslt).indexOf(101);
            if (idx == -1 && (idx = ((String)rslt).indexOf(69)) == -1) {
                idx = ((String)rslt).length();
            }
            rslt = ((String)rslt).substring(0, idx) + ".0" + ((String)rslt).substring(idx);
        }
        textBuilder.append((String)rslt);
    }

    private void toText(PlcEnumLiteral enumLit, StringBuilder textBuilder) {
        textBuilder.append(enumLit.value);
    }

    private void toText(PlcArrayLiteral arrayLit, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append("[");
        boolean first = true;
        for (PlcExpression value : arrayLit.values) {
            if (!first) {
                textBuilder.append(", ");
            }
            first = false;
            this.toText(value, textBuilder, funcApplPreference);
        }
        textBuilder.append("]");
    }

    private void toText(PlcStructLiteral structLit, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append("(");
        boolean first = true;
        for (PlcNamedValue namedValue : structLit.values) {
            if (!first) {
                textBuilder.append(", ");
            }
            first = false;
            textBuilder.append(namedValue.name);
            textBuilder.append(" := ");
            this.toText(namedValue.value, textBuilder, funcApplPreference);
        }
        textBuilder.append(")");
    }

    /*
     * WARNING - void declaration
     */
    private void toText(PlcFuncAppl funcAppl, StringBuilder textBuilder, PlcBasicFuncDescription.ExprBinding parentBinding, boolean atParentLeft, boolean atParentRight, FuncApplPreference funcApplPreference) {
        PlcBasicFuncDescription basicDescr = funcAppl.function;
        Map<String, PlcNamedValue> arguments = funcAppl.arguments;
        boolean allArgumentsSupplied = basicDescr.parameters.length == arguments.size();
        boolean infixNotationAllowed = basicDescr.notations.contains((Object)PlcBasicFuncDescription.PlcFuncNotation.INFIX) && funcApplPreference != FuncApplPreference.OUTER_PREFIX && allArgumentsSupplied;
        boolean informalNotationAllowed = basicDescr.notations.contains((Object)PlcBasicFuncDescription.PlcFuncNotation.INFORMAL) && allArgumentsSupplied;
        boolean formalNotationAllowed = basicDescr.notations.contains((Object)PlcBasicFuncDescription.PlcFuncNotation.FORMAL);
        Assert.check((infixNotationAllowed || informalNotationAllowed || formalNotationAllowed ? 1 : 0) != 0);
        if (infixNotationAllowed) {
            void plainFunc;
            if (!(basicDescr instanceof PlcPlainFuncDescription)) {
                throw new AssertionError((Object)"Function allows infix notation but does not supply infix notation data.");
            }
            PlcPlainFuncDescription plcPlainFuncDescription = (PlcPlainFuncDescription)basicDescr;
            PlcBasicFuncDescription.ExprBinding infixBinding = plainFunc.infixBinding;
            String infixFuncName = plainFunc.infixFuncName;
            Assert.notNull((Object)infixFuncName);
            int lastArgumentIndex = arguments.size() - 1;
            boolean isUnaryOperation = lastArgumentIndex == 0;
            boolean needsParentheses = infixBinding.needsParentheses(parentBinding, atParentLeft, atParentRight, this.target);
            textBuilder.append((needsParentheses |= isUnaryOperation) ? "(" : "");
            if (isUnaryOperation) {
                textBuilder.append(infixFuncName);
            }
            String infixString = " " + infixFuncName + " ";
            int argNumber = 0;
            PlcBasicFuncDescription.PlcParameterDescription[] plcParameterDescriptionArray = basicDescr.parameters;
            int n = basicDescr.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                PlcBasicFuncDescription.PlcParameterDescription param = plcParameterDescriptionArray[n2];
                PlcNamedValue argNamedValue = arguments.get(param.name);
                Assert.notNull((Object)argNamedValue);
                textBuilder.append((String)(argNumber > 0 ? infixString : ""));
                this.toText(argNamedValue.value, textBuilder, infixBinding, argNumber == 0, argNumber == lastArgumentIndex, FuncApplPreference.PREFER_INFIX);
                ++argNumber;
                ++n2;
            }
            textBuilder.append(needsParentheses ? ")" : "");
        } else if (informalNotationAllowed || formalNotationAllowed) {
            Object prefixFuncName;
            Object typeExtension = "";
            if (basicDescr.typeExtension.testFunction.test(funcAppl.type)) {
                typeExtension = "_" + this.getTypeName(funcAppl.type);
            }
            if (funcAppl instanceof PlcFuncBlockAppl) {
                PlcFuncBlockAppl blockAppl = (PlcFuncBlockAppl)funcAppl;
                prefixFuncName = blockAppl.variable.varName;
                if (!basicDescr.prefixFuncName.isEmpty()) {
                    prefixFuncName = (String)prefixFuncName + "." + basicDescr.prefixFuncName;
                }
            } else {
                prefixFuncName = basicDescr.prefixFuncName + (String)typeExtension;
            }
            Assert.notNull((Object)prefixFuncName);
            textBuilder.append((String)prefixFuncName);
            textBuilder.append("(");
            int argNumber = 0;
            boolean useFormalSyntax = !informalNotationAllowed;
            PlcBasicFuncDescription.PlcParameterDescription[] plcParameterDescriptionArray = basicDescr.parameters;
            int n = basicDescr.parameters.length;
            int n3 = 0;
            while (n3 < n) {
                PlcBasicFuncDescription.PlcParameterDescription param = plcParameterDescriptionArray[n3];
                PlcNamedValue argNamedValue = arguments.get(param.name);
                if (argNamedValue != null) {
                    textBuilder.append(argNumber > 0 ? ", " : "");
                    if (useFormalSyntax) {
                        textBuilder.append(param.name);
                        textBuilder.append(param.direction == PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY ? " => " : " := ");
                    }
                    this.toText(argNamedValue.value, textBuilder, FuncApplPreference.PREFER_INFIX);
                    ++argNumber;
                }
                ++n3;
            }
            textBuilder.append(")");
        } else {
            throw new AssertionError((Object)"Failed to convert the function application to text.");
        }
    }

    private String getTypeName(PlcType type) {
        if (type instanceof PlcElementaryType) {
            PlcElementaryType elemType = (PlcElementaryType)type;
            return elemType.name;
        }
        if (type instanceof PlcEnumType) {
            PlcEnumType enumType = (PlcEnumType)type;
            return enumType.getName();
        }
        if (type instanceof PlcStructType) {
            PlcStructType structType = (PlcStructType)type;
            return structType.getName();
        }
        throw new AssertionError((Object)("Cannot extract a type name from \"" + String.valueOf(type) + "\"."));
    }

    private void toText(PlcVarExpression varExpr, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append(varExpr.variable.targetText);
        for (PlcVarExpression.PlcProjection proj : varExpr.projections) {
            this.toText(proj, textBuilder, funcApplPreference);
        }
    }

    private void toText(PlcVarExpression.PlcProjection proj, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        if (proj instanceof PlcVarExpression.PlcStructProjection) {
            PlcVarExpression.PlcStructProjection structProj = (PlcVarExpression.PlcStructProjection)proj;
            textBuilder.append(".");
            textBuilder.append(structProj.fieldName);
        } else if (proj instanceof PlcVarExpression.PlcArrayProjection) {
            PlcVarExpression.PlcArrayProjection arrayProj = (PlcVarExpression.PlcArrayProjection)proj;
            textBuilder.append('[');
            this.toText(arrayProj.indexExpression, textBuilder, funcApplPreference);
            textBuilder.append(']');
        } else {
            throw new AssertionError((Object)("Unexpected PLC projection \"" + String.valueOf(proj) + "\" found."));
        }
    }

    public String toString(List<PlcStatement> plcStats, String pouName, boolean fixCodeBlock) {
        MemoryCodeBox boxBuilder = new MemoryCodeBox();
        this.toText(plcStats, (CodeBox)boxBuilder, pouName, fixCodeBlock);
        return boxBuilder.toString();
    }

    public void toText(List<PlcStatement> plcStats, CodeBox boxBuilder, String pouName, boolean fixCodeBlock) {
        boolean foundStat = false;
        for (PlcStatement plcStat : plcStats) {
            this.toText(plcStat, boxBuilder, pouName);
            foundStat |= plcStat.isProperPlcStatement();
        }
        if (!foundStat) {
            if (fixCodeBlock) {
                this.toText(new PlcCommentLine("Nothing to do.", true), boxBuilder, pouName);
            } else {
                throw new AssertionError((Object)"Code block does not have a proper PLC statement.");
            }
        }
    }

    public String toString(PlcStatement plcStat, String pouName) {
        MemoryCodeBox boxBuilder = new MemoryCodeBox();
        this.toText(plcStat, (CodeBox)boxBuilder, pouName);
        return boxBuilder.toString();
    }

    public void toText(PlcStatement plcStat, CodeBox boxBuilder, String pouName) {
        if (plcStat instanceof PlcAssignmentStatement) {
            PlcAssignmentStatement asgStat = (PlcAssignmentStatement)plcStat;
            this.toText(asgStat, boxBuilder, pouName);
        } else if (plcStat instanceof PlcCommentLine) {
            PlcCommentLine cmtLine = (PlcCommentLine)plcStat;
            this.toText(cmtLine, boxBuilder, pouName);
        } else if (plcStat instanceof PlcCommentBlock) {
            PlcCommentBlock cmtBlock = (PlcCommentBlock)plcStat;
            this.toText(cmtBlock, boxBuilder, pouName);
        } else if (plcStat instanceof PlcReturnStatement) {
            PlcReturnStatement retStat = (PlcReturnStatement)plcStat;
            this.toText(retStat, boxBuilder, pouName);
        } else if (plcStat instanceof PlcSelectionStatement) {
            PlcSelectionStatement selStat = (PlcSelectionStatement)plcStat;
            this.toText(selStat, boxBuilder, pouName);
        } else if (plcStat instanceof PlcFuncApplStatement) {
            PlcFuncApplStatement funcApplStat = (PlcFuncApplStatement)plcStat;
            this.toText(funcApplStat, boxBuilder, pouName);
        } else {
            throw new AssertionError((Object)("Unexpected PLC statement \"" + String.valueOf(plcStat) + "\" found."));
        }
    }

    private void toText(PlcAssignmentStatement asgStat, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("%s := %s;", new Object[]{this.toString(asgStat.lhs), this.toString(asgStat.value)});
    }

    private void toText(PlcCommentLine cmtLine, CodeBox boxBuilder, String pouName) {
        if (cmtLine.commentText == null) {
            boxBuilder.add("%s", new Object[]{cmtLine.isEmptyStatement ? ";" : ""});
        } else {
            boxBuilder.add("(* %s *)%s", new Object[]{cmtLine.commentText, cmtLine.isEmptyStatement ? " ;" : ""});
        }
    }

    private void toText(PlcCommentBlock cmtBlock, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("(*" + Strings.duplicate((String)"*", (int)cmtBlock.starCount));
        for (String line : cmtBlock.lines) {
            boxBuilder.add(" * " + line);
        }
        boxBuilder.add(" " + Strings.duplicate((String)"*", (int)cmtBlock.starCount) + "*)");
    }

    private void toText(PlcFuncApplStatement funcApplStat, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("%s;", new Object[]{this.toString(funcApplStat.funcApplExpr, FuncApplPreference.OUTER_PREFIX)});
    }

    private void toText(PlcReturnStatement retStat, CodeBox boxBuilder, String pouName) {
        if (retStat.returnValue != null) {
            boxBuilder.add("%s := %s;", new Object[]{pouName, this.toString(retStat.returnValue)});
        }
        boxBuilder.add("RETURN;");
    }

    private void toText(PlcSelectionStatement selStat, CodeBox boxBuilder, String pouName) {
        if (selStat.condChoices.isEmpty()) {
            this.toText(selStat.elseStats, boxBuilder, pouName, true);
            return;
        }
        String testText = "IF";
        for (PlcSelectionStatement.PlcSelectChoice condChoice : selStat.condChoices) {
            boxBuilder.add("%s %s THEN", new Object[]{testText, this.toString(condChoice.guard)});
            testText = "ELSIF";
            boxBuilder.indent();
            this.toText(condChoice.thenStats, boxBuilder, pouName, true);
            boxBuilder.dedent();
        }
        if (!selStat.elseStats.isEmpty()) {
            boxBuilder.add("ELSE");
            boxBuilder.indent();
            this.toText(selStat.elseStats, boxBuilder, pouName, true);
            boxBuilder.dedent();
        }
        boxBuilder.add("END_IF;");
    }

    public static enum FuncApplPreference {
        PREFER_INFIX,
        OUTER_PREFIX;

    }
}

