/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.cssparser.parser.AbstractLocatable;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.parser.CSSParseException;
import org.htmlunit.cssparser.parser.media.MediaQuery;
import org.htmlunit.cssparser.parser.media.MediaQueryList;
import org.htmlunit.cssparser.util.ParserUtils;
import org.htmlunit.cssparser.util.ThrowCssExceptionErrorHandler;
import org.w3c.dom.DOMException;

public class MediaListImpl
extends AbstractLocatable
implements Serializable {
    private final List<MediaQuery> mediaQueries_ = new ArrayList<MediaQuery>(10);

    public MediaListImpl(MediaQueryList mediaList) {
        this.setMediaList(mediaList);
        if (mediaList != null) {
            this.setLocator(mediaList.getLocator());
        }
    }

    public String getMediaText() {
        StringBuilder sb = new StringBuilder();
        boolean isNotFirst = false;
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            if (isNotFirst) {
                sb.append(", ");
            } else {
                isNotFirst = true;
            }
            sb.append(mediaQuery.toString());
        }
        return sb.toString();
    }

    public void setMediaText(String mediaText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            MediaQueryList sml = parser.parseMedia(mediaText);
            this.setMediaList(sml);
        }
        catch (CSSParseException e) {
            throw new DOMException(12, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new DOMException(8, e.getLocalizedMessage());
        }
    }

    public int getLength() {
        return this.mediaQueries_.size();
    }

    public MediaQuery mediaQuery(int index) {
        if (index < 0 || index >= this.mediaQueries_.size()) {
            return null;
        }
        return this.mediaQueries_.get(index);
    }

    public String toString() {
        return this.getMediaText();
    }

    public void setMedia(List<String> media) {
        this.mediaQueries_.clear();
        for (String medium : media) {
            this.mediaQueries_.add(new MediaQuery(medium));
        }
    }

    private void setMediaList(MediaQueryList mediaList) {
        if (mediaList != null) {
            this.mediaQueries_.addAll(mediaList.getMediaQueries());
        }
    }

    private boolean equalsMedia(MediaListImpl ml) {
        if (ml == null || this.getLength() != ml.getLength()) {
            return false;
        }
        int i = 0;
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            String m2;
            String m1 = mediaQuery.getMedia();
            if (!ParserUtils.equals(m1, m2 = ml.mediaQuery(i).getMedia())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaListImpl)) {
            return false;
        }
        MediaListImpl ml = (MediaListImpl)obj;
        return super.equals(obj) && this.equalsMedia(ml);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = ParserUtils.hashCode(hash, this.mediaQueries_);
        return hash;
    }
}

