/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.DefaultLauncherConfig;

@API(status=API.Status.STABLE, since="1.7")
public interface LauncherConfig {
    public static final LauncherConfig DEFAULT = LauncherConfig.builder().build();

    public boolean isTestEngineAutoRegistrationEnabled();

    @API(status=API.Status.STABLE, since="1.10")
    public boolean isLauncherSessionListenerAutoRegistrationEnabled();

    @API(status=API.Status.STABLE, since="1.10")
    public boolean isLauncherDiscoveryListenerAutoRegistrationEnabled();

    public boolean isTestExecutionListenerAutoRegistrationEnabled();

    @API(status=API.Status.STABLE, since="1.10")
    public boolean isPostDiscoveryFilterAutoRegistrationEnabled();

    public Collection<TestEngine> getAdditionalTestEngines();

    @API(status=API.Status.STABLE, since="1.10")
    public Collection<LauncherSessionListener> getAdditionalLauncherSessionListeners();

    @API(status=API.Status.STABLE, since="1.10")
    public Collection<LauncherDiscoveryListener> getAdditionalLauncherDiscoveryListeners();

    public Collection<TestExecutionListener> getAdditionalTestExecutionListeners();

    @API(status=API.Status.STABLE, since="1.10")
    public Collection<PostDiscoveryFilter> getAdditionalPostDiscoveryFilters();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean engineAutoRegistrationEnabled = true;
        private boolean launcherSessionListenerAutoRegistrationEnabled = true;
        private boolean launcherDiscoveryListenerAutoRegistrationEnabled = true;
        private boolean testExecutionListenerAutoRegistrationEnabled = true;
        private boolean postDiscoveryFilterAutoRegistrationEnabled = true;
        private final Collection<TestEngine> engines = new LinkedHashSet<TestEngine>();
        private final Collection<LauncherSessionListener> sessionListeners = new LinkedHashSet<LauncherSessionListener>();
        private final Collection<LauncherDiscoveryListener> discoveryListeners = new LinkedHashSet<LauncherDiscoveryListener>();
        private final Collection<TestExecutionListener> executionListeners = new LinkedHashSet<TestExecutionListener>();
        private final Collection<PostDiscoveryFilter> postDiscoveryFilters = new LinkedHashSet<PostDiscoveryFilter>();

        private Builder() {
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder enableLauncherSessionListenerAutoRegistration(boolean enabled) {
            this.launcherSessionListenerAutoRegistrationEnabled = enabled;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder enableLauncherDiscoveryListenerAutoRegistration(boolean enabled) {
            this.launcherDiscoveryListenerAutoRegistrationEnabled = enabled;
            return this;
        }

        public Builder enableTestExecutionListenerAutoRegistration(boolean enabled) {
            this.testExecutionListenerAutoRegistrationEnabled = enabled;
            return this;
        }

        public Builder enableTestEngineAutoRegistration(boolean enabled) {
            this.engineAutoRegistrationEnabled = enabled;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder enablePostDiscoveryFilterAutoRegistration(boolean enabled) {
            this.postDiscoveryFilterAutoRegistrationEnabled = enabled;
            return this;
        }

        public Builder addTestEngines(TestEngine ... engines) {
            Preconditions.notNull(engines, "TestEngine array must not be null");
            Preconditions.containsNoNullElements(engines, "TestEngine array must not contain null elements");
            Collections.addAll(this.engines, engines);
            return this;
        }

        public Builder addLauncherSessionListeners(LauncherSessionListener ... listeners) {
            Preconditions.notNull(listeners, "LauncherSessionListener array must not be null");
            Preconditions.containsNoNullElements(listeners, "LauncherSessionListener array must not contain null elements");
            Collections.addAll(this.sessionListeners, listeners);
            return this;
        }

        public Builder addLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
            Preconditions.notNull(listeners, "LauncherDiscoveryListener array must not be null");
            Preconditions.containsNoNullElements(listeners, "LauncherDiscoveryListener array must not contain null elements");
            Collections.addAll(this.discoveryListeners, listeners);
            return this;
        }

        public Builder addTestExecutionListeners(TestExecutionListener ... listeners) {
            Preconditions.notNull(listeners, "TestExecutionListener array must not be null");
            Preconditions.containsNoNullElements(listeners, "TestExecutionListener array must not contain null elements");
            Collections.addAll(this.executionListeners, listeners);
            return this;
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder addPostDiscoveryFilters(PostDiscoveryFilter ... filters) {
            Preconditions.notNull(filters, "PostDiscoveryFilter array must not be null");
            Preconditions.containsNoNullElements(filters, "PostDiscoveryFilter array must not contain null elements");
            Collections.addAll(this.postDiscoveryFilters, filters);
            return this;
        }

        public LauncherConfig build() {
            return new DefaultLauncherConfig(this.engineAutoRegistrationEnabled, this.launcherSessionListenerAutoRegistrationEnabled, this.launcherDiscoveryListenerAutoRegistrationEnabled, this.testExecutionListenerAutoRegistrationEnabled, this.postDiscoveryFilterAutoRegistrationEnabled, this.engines, this.sessionListeners, this.discoveryListeners, this.executionListeners, this.postDiscoveryFilters);
        }
    }
}

