/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.NodeConstraint;
import org.apache.jena.shex.expressions.SemAct;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.sys.ValidationContext;

public class ShapeNodeConstraint
extends ShapeExpression {
    private final NodeConstraint nodeConstraint;

    public ShapeNodeConstraint(NodeConstraint nodeConstraint, List<SemAct> semActs) {
        this(null, Objects.requireNonNull(nodeConstraint, "NodeConstraint"), semActs);
    }

    private ShapeNodeConstraint(ShapeExpression shapeExpression, NodeConstraint nodeConstraint, List<SemAct> semActs) {
        super(semActs);
        this.nodeConstraint = nodeConstraint;
    }

    public NodeConstraint getNodeConstraint() {
        return this.nodeConstraint;
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        out.println(this.toString());
    }

    @Override
    public boolean satisfies(ValidationContext vCxt, Node data) {
        return this.nodeConstraint.satisfies(vCxt, data);
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return 1 + Objects.hash(this.nodeConstraint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShapeNodeConstraint other = (ShapeNodeConstraint)obj;
        return Objects.equals(this.nodeConstraint, other.nodeConstraint);
    }

    @Override
    public String toString() {
        if (this.nodeConstraint != null) {
            return "ShapeNodeConstraint [ " + this.nodeConstraint + " ]";
        }
        return "ShapeNodeConstraint []";
    }
}

