/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.Violation;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.SetupJenaIRI;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.SplitIRI;

public class Checker {
    private static final Pattern langPattern = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
    private static ErrorHandler nullErrorHandler = new ErrorHandler(){

        @Override
        public void warning(String message, long line, long col) {
        }

        @Override
        public void error(String message, long line, long col) {
        }

        @Override
        public void fatal(String message, long line, long col) {
        }
    };

    public static boolean check(Node node) {
        return Checker.check(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean check(Node node, ErrorHandler errorHandler, long line, long col) {
        if (node.isURI()) {
            return Checker.checkIRI(node, errorHandler, line, col);
        }
        if (node.isBlank()) {
            return Checker.checkBlankNode(node, errorHandler, line, col);
        }
        if (node.isLiteral()) {
            return Checker.checkLiteral(node, errorHandler, line, col);
        }
        if (node.isVariable()) {
            return Checker.checkVar(node, errorHandler, line, col);
        }
        if (node.isNodeTriple()) {
            Triple t = node.getTriple();
            return Checker.check(t.getSubject()) && Checker.check(t.getPredicate()) && Checker.check(t.getObject()) && Checker.checkTriple(t);
        }
        Checker.errorHandler(errorHandler).warning("Not a recognized node: ", line, col);
        return false;
    }

    public static boolean checkIRI(Node node) {
        return Checker.checkIRI(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkIRI(Node node, ErrorHandler errorHandler, long line, long col) {
        if (!node.isURI()) {
            Checker.errorHandler(errorHandler).error("Not a URI: " + node, line, col);
            return false;
        }
        return Checker.checkIRI(node.getURI(), errorHandler, line, col);
    }

    public static boolean checkIRI(String iriStr) {
        return Checker.checkIRI(iriStr, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkIRI(String iriStr, ErrorHandler errorHandler, long line, long col) {
        IRI iri = SetupJenaIRI.iriCheckerFactory().create(iriStr);
        boolean b = Checker.iriViolations(iri, errorHandler, line, col);
        return b;
    }

    public static void iriViolations(IRI iri) {
        Checker.iriViolations(iri, nullErrorHandler, false, true, -1L, -1L);
    }

    public static boolean iriViolations(IRI iri, ErrorHandler errorHandler, long line, long col) {
        return Checker.iriViolations(iri, errorHandler, false, true, line, col);
    }

    public static boolean iriViolations(IRI iri, ErrorHandler errorHandler, boolean allowRelativeIRIs, boolean includeIRIwarnings, long line, long col) {
        if (!allowRelativeIRIs && iri.isRelative()) {
            Checker.iriViolationMessage(iri.toString(), true, "Relative IRI: " + iri, line, col, errorHandler);
        }
        boolean isOK = true;
        if (iri.hasViolation(includeIRIwarnings)) {
            Iterator<Violation> iter = iri.violations(includeIRIwarnings);
            while (iter.hasNext()) {
                Violation v = iter.next();
                int code = v.getViolationCode();
                boolean isError = v.isError();
                if (code == 11 && v.getComponent() != 2) continue;
                isOK = false;
                String msg = v.getShortMessage();
                String iriStr = iri.toString();
                Checker.iriViolationMessage(iriStr, isError, msg, line, col, errorHandler);
            }
        }
        return isOK;
    }

    public static void iriViolationMessage(String iriStr, boolean isError, String msg, long line, long col, ErrorHandler errorHandler) {
        try {
            if (!(SystemIRIx.getProvider() instanceof IRIProviderJenaIRI)) {
                msg = "<" + iriStr + "> : " + (String)msg;
            }
            if (isError) {
                Checker.errorHandler(errorHandler).warning("Bad IRI: " + (String)msg, line, col);
            } else {
                Checker.errorHandler(errorHandler).warning("Not advised IRI: " + (String)msg, line, col);
            }
        }
        catch (org.apache.jena.iri.IRIException | IRIException runtimeException) {
            // empty catch block
        }
    }

    public static boolean checkLiteral(Node node) {
        return Checker.checkLiteral(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkLiteral(Node node, ErrorHandler errorHandler, long line, long col) {
        if (!node.isLiteral()) {
            Checker.errorHandler(errorHandler).error("Not a literal: " + node, line, col);
            return false;
        }
        return Checker.checkLiteral(node.getLiteralLexicalForm(), node.getLiteralLanguage(), node.getLiteralDatatype(), errorHandler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkLiteral(lexicalForm, null, datatype, errorHandler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, String lang, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkLiteral(lexicalForm, lang, null, errorHandler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, String lang, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        boolean hasDatatype;
        boolean hasLang = lang != null && !lang.isEmpty();
        boolean bl = hasDatatype = datatype != null;
        if (!hasDatatype && !hasLang) {
            return true;
        }
        if (hasLang) {
            if (!langPattern.matcher(lang).matches()) {
                Checker.errorHandler(errorHandler).warning("Language not valid: " + lang, line, col);
                return false;
            }
            if (hasDatatype && !datatype.equals(RDFLangString.rdfLangString)) {
                Checker.errorHandler(errorHandler).error("Literal has language but wrong datatype", line, col);
                return false;
            }
            return true;
        }
        if (datatype.equals(XSDDatatype.XSDstring)) {
            return true;
        }
        return Checker.validateByDatatype(lexicalForm, datatype, errorHandler, line, col);
    }

    protected static boolean validateByDatatype(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        return Checker.validateByDatatypeJena(lexicalForm, datatype, errorHandler, line, col);
    }

    protected static boolean validateByDatatypeJena(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        if (datatype.isValid(lexicalForm)) {
            return true;
        }
        Checker.errorHandler(errorHandler).warning("Lexical form '" + lexicalForm + "' not valid for datatype " + Checker.xsdDatatypeName(datatype), line, col);
        return false;
    }

    protected static boolean checkWhitespace(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        if (lexicalForm.contains(" ")) {
            Checker.errorHandler(errorHandler).warning("Whitespace in " + Checker.xsdDatatypeName(datatype) + " literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\n")) {
            Checker.errorHandler(errorHandler).warning("Newline in " + Checker.xsdDatatypeName(datatype) + " literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\r")) {
            Checker.errorHandler(errorHandler).warning("Newline in " + Checker.xsdDatatypeName(datatype) + " literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        return true;
    }

    private static String xsdDatatypeName(RDFDatatype datatype) {
        return "XSD " + SplitIRI.localname(datatype.getURI());
    }

    public static boolean checkBlankNode(Node node) {
        return Checker.checkBlankNode(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkBlankNode(Node node, ErrorHandler errorHandler, long line, long col) {
        if (!node.isBlank()) {
            Checker.errorHandler(errorHandler).error("Not a blank node: " + node, line, col);
            return false;
        }
        return Checker.checkBlankNode(node.getBlankNodeLabel(), errorHandler, line, col);
    }

    public static boolean checkBlankNode(String label) {
        return Checker.checkBlankNode(label, null, -1L, -1L);
    }

    public static boolean checkBlankNode(String label, ErrorHandler errorHandler, long line, long col) {
        if (label.indexOf(32) >= 0) {
            Checker.errorHandler(errorHandler).error("Illegal blank node label (contains a space): " + label, line, col);
            return false;
        }
        return true;
    }

    public static boolean checkVar(Node node) {
        return Checker.checkVar(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkVar(Node node, ErrorHandler errorHandler, long line, long col) {
        if (node.isVariable()) {
            Checker.errorHandler(errorHandler).error("Not a variable: " + node, line, col);
            return false;
        }
        return true;
    }

    public static boolean checkTriple(Triple triple) {
        return Checker.checkTriple(triple, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkTriple(Triple triple, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkTriple(triple.getSubject(), triple.getPredicate(), triple.getObject(), errorHandler, line, col);
    }

    public static boolean checkTriple(Node subject, Node predicate, Node object, ErrorHandler errorHandler, long line, long col) {
        boolean rc = true;
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            Checker.errorHandler(errorHandler).error("Subject is not a URI or blank node", line, col);
            rc = false;
        }
        if (predicate == null || !predicate.isURI()) {
            Checker.errorHandler(errorHandler).error("Predicate not a URI", line, col);
            rc = false;
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            Checker.errorHandler(errorHandler).error("Object is not a URI, blank node or literal", line, col);
            rc = false;
        }
        return rc;
    }

    public static boolean checkQuad(Quad quad) {
        return Checker.checkQuad(quad, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkQuad(Quad quad, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkQuad(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject(), errorHandler, line, col);
    }

    public static boolean checkQuad(Node graph, Node subject, Node predicate, Node object, ErrorHandler errorHandler, long line, long col) {
        boolean rc = true;
        if (graph == null || !graph.isURI() && !graph.isBlank()) {
            Checker.errorHandler(errorHandler).error("Graph name is not a URI or blank node", line, col);
            rc = false;
        }
        if (subject == null || !subject.isURI() && !subject.isBlank() && !subject.isNodeTriple()) {
            Checker.errorHandler(errorHandler).error("Subject is not a URI, blank node or RDF-star triple term", line, col);
            rc = false;
        }
        if (predicate == null || !predicate.isURI()) {
            Checker.errorHandler(errorHandler).error("Predicate not a URI", line, col);
            rc = false;
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral() && !subject.isNodeTriple()) {
            Checker.errorHandler(errorHandler).error("Object is not a URI, blank node, literal or RDF-star triple term", line, col);
            rc = false;
        }
        return rc;
    }

    private static ErrorHandler errorHandler(ErrorHandler handler) {
        return handler != null ? handler : ErrorHandlerFactory.errorHandlerStd;
    }
}

