/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Resource;

public final class HierarchySupport {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <X extends OntObject> boolean contains(X root2, X test, Function<X, Stream<X>> listChildren, boolean direct, boolean useBuiltinHierarchySupport) {
        if (direct) {
            return HierarchySupport.hasDirectNode(root2, test, useBuiltinHierarchySupport, listChildren);
        }
        if (useBuiltinHierarchySupport) {
            return HierarchySupport.hasIndirectNode(root2, test, listChildren);
        }
        if (root2.equals(test)) return false;
        if (!listChildren.apply(root2).anyMatch(test::equals)) return false;
        return true;
    }

    public static <X extends OntObject> Stream<X> treeNodes(X root2, Function<X, Stream<X>> listChildren, boolean direct, boolean useBuiltinHierarchySupport) {
        if (direct) {
            return HierarchySupport.directNodesAsStream(root2, useBuiltinHierarchySupport, listChildren);
        }
        if (useBuiltinHierarchySupport) {
            return HierarchySupport.indirectNodesAsStream(root2, listChildren);
        }
        return listChildren.apply(root2).filter(x -> !root2.equals(x));
    }

    static <X extends Resource> Stream<X> indirectNodesAsStream(X root2, Function<X, Stream<X>> listChildren) {
        return Iterators.fromSet(() -> {
            HashSet res = new HashSet();
            Function<Resource, Set> getChildren = it -> ((Stream)listChildren.apply(it)).collect(Collectors.toSet());
            HierarchySupport.collectIndirect(root2, getChildren, res);
            res.remove(root2);
            return res;
        });
    }

    static <X extends Resource> boolean hasIndirectNode(X root2, X test, Function<X, Stream<X>> listChildren) {
        if (root2.equals(test)) {
            return false;
        }
        HashSet<Resource> seen = new HashSet<Resource>();
        ArrayDeque<Resource> queue = new ArrayDeque<Resource>();
        queue.add(root2);
        while (!queue.isEmpty()) {
            Resource next = (Resource)queue.removeFirst();
            if (!seen.add(next)) continue;
            Stream<X> children = listChildren.apply(next);
            try {
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    Resource child = (Resource)it.next();
                    if (child.equals(test)) {
                        boolean bl = true;
                        return bl;
                    }
                    queue.add(child);
                }
            }
            finally {
                if (children == null) continue;
                children.close();
            }
        }
        return false;
    }

    public static <X extends Resource> Set<X> allTreeNodesSetInclusive(Supplier<Stream<X>> listRoots, Function<X, Stream<X>> listChildren) {
        HashSet res = new HashSet();
        HashMap childrenNodesCache = new HashMap();
        Function<Resource, Set> getChildren = it -> HierarchySupport.getChildren(it, listChildren, childrenNodesCache);
        try (Stream<X> roots = listRoots.get();){
            roots.forEach(root2 -> HierarchySupport.collectIndirect(root2, getChildren, res));
        }
        return res;
    }

    static <X extends Resource> void collectIndirect(X root2, Function<X, Set<X>> getChildren, Set<X> res) {
        ArrayDeque<X> queue = new ArrayDeque<X>();
        queue.add(root2);
        while (!queue.isEmpty()) {
            Resource next = (Resource)queue.removeFirst();
            if (!res.add(next)) continue;
            queue.addAll((Collection)getChildren.apply(next));
        }
    }

    public static <X extends Resource> Stream<X> directNodesAsStream(X object, boolean useBuiltinHierarchySupport, Function<X, Stream<X>> listChildren) {
        return Iterators.fromSet(() -> useBuiltinHierarchySupport ? HierarchySupport.directNodesAsSetWithBuiltinInf(object, listChildren) : HierarchySupport.directNodesAsSetStandard(object, listChildren));
    }

    public static <X extends Resource> boolean hasDirectNode(X object, X test, boolean useBuiltinHierarchySupport, Function<X, Stream<X>> listChildren) {
        return useBuiltinHierarchySupport ? HierarchySupport.hasDirectNodeWithBuiltinInf(object, test, listChildren) : HierarchySupport.hasDirectNodeStandard(object, test, listChildren);
    }

    public static <X extends Resource> Set<X> directNodesAsSetStandard(X root2, Function<X, Stream<X>> listChildren) {
        HashMap childrenNodesCache = new HashMap();
        Function<Resource, Set> getChildren = it -> HierarchySupport.getChildren(it, listChildren, childrenNodesCache);
        return getChildren.apply(root2).stream().filter(it -> !HierarchySupport.equivalent(it, root2, getChildren) && !HierarchySupport.hasAnotherPath(it, root2, getChildren)).collect(Collectors.toSet());
    }

    public static <X extends Resource> Set<X> directNodesAsSetWithBuiltinInf(X root2, Function<X, Stream<X>> listChildren) {
        Map<X, Node<X>> tree = HierarchySupport.collectTree(root2, listChildren);
        Node theRoot = tree.get(root2);
        return theRoot.childrenWithEquivalents().flatMap(it -> HierarchySupport.collectDirect(theRoot, it)).collect(Collectors.toSet());
    }

    public static <X extends Resource> boolean hasDirectNodeStandard(X root2, X test, Function<X, Stream<X>> listChildren) {
        HashMap childrenNodesCache = new HashMap();
        Function<Resource, Set> getChildren = it -> HierarchySupport.getChildren(it, listChildren, childrenNodesCache);
        return getChildren.apply(root2).stream().anyMatch(it -> test.equals(it) && !HierarchySupport.equivalent(it, root2, getChildren) && !HierarchySupport.hasAnotherPath(it, root2, getChildren));
    }

    public static <X extends Resource> boolean hasDirectNodeWithBuiltinInf(X root2, X test, Function<X, Stream<X>> listChildren) {
        Map<X, Node<X>> tree = HierarchySupport.collectTree(root2, listChildren);
        Node theRoot = tree.get(root2);
        return theRoot.childrenWithEquivalents().anyMatch(it -> HierarchySupport.hasDirectNode(theRoot, it, test));
    }

    private static <X extends Resource> boolean hasAnotherPath(X given, X root2, Function<X, Set<X>> getChildren) {
        return getChildren.apply(root2).stream().filter(it -> !HierarchySupport.equivalent(it, root2, getChildren)).flatMap(it -> ((Set)getChildren.apply(it)).stream().filter(x -> !HierarchySupport.equivalent(x, it, getChildren))).anyMatch(given::equals);
    }

    private static <X extends Resource> boolean equivalent(X left, X right, Function<X, Set<X>> getChildren) {
        return getChildren.apply(right).contains(left) && getChildren.apply(left).contains(right);
    }

    private static <X extends Resource> Stream<X> collectDirect(Node<X> rootNode, Node<X> current) {
        Set<X> equivalents = current.equivalents();
        if (!equivalents.contains(rootNode.node)) {
            HashSet<X> siblings = new HashSet<X>(equivalents);
            siblings.remove(current.node);
            if (current.hasMoreThanOnePathTo(rootNode, siblings)) {
                return Stream.empty();
            }
            equivalents.add(current.node);
            return equivalents.stream();
        }
        return Stream.empty();
    }

    private static <X extends Resource> boolean hasDirectNode(Node<X> rootNode, Node<X> current, X test) {
        Set<X> equivalents = current.equivalents();
        if (!equivalents.contains(rootNode.node)) {
            HashSet<X> siblings = new HashSet<X>(equivalents);
            siblings.remove(current.node);
            if (current.hasMoreThanOnePathTo(rootNode, siblings)) {
                return false;
            }
            return current.node.equals(test) || equivalents.contains(test);
        }
        return false;
    }

    private static <X extends Resource> Map<X, Node<X>> collectTree(X root2, Function<X, Stream<X>> listChildren) {
        HashMap childrenNodesCache = new HashMap();
        HashMap<Resource, Node> res = new HashMap<Resource, Node>();
        HashSet<Resource> visited = new HashSet<Resource>();
        ArrayDeque queue = new ArrayDeque();
        queue.add(root2);
        while (!queue.isEmpty()) {
            Resource next = (Resource)queue.removeFirst();
            if (!visited.add(next)) continue;
            Set<Resource> nextChildren = HierarchySupport.getChildren(next, listChildren, childrenNodesCache);
            Node nextNode = res.computeIfAbsent(next, Node::new);
            nextChildren.forEach(child -> {
                Node childNode = res.computeIfAbsent((Resource)child, Node::new);
                nextNode.children.add(childNode);
                queue.add((Resource)child);
            });
        }
        return res;
    }

    private static <X extends Resource> Set<X> getChildren(X root2, Function<X, Stream<X>> listChildren, Map<X, Set<X>> childrenNodesCache) {
        return childrenNodesCache.computeIfAbsent(root2, it -> {
            try (Stream children = (Stream)listChildren.apply(it);){
                Set set = children.collect(Collectors.toSet());
                return set;
            }
        });
    }

    private static class Node<X extends Resource> {
        final X node;
        final Set<Node<X>> children = new HashSet<Node<X>>();

        Node(X node) {
            this.node = node;
        }

        Stream<Node<X>> childrenWithEquivalents() {
            Set<X> equivalents = this.equivalents();
            return this.children.stream().flatMap(ch -> {
                if (equivalents.contains(ch.node)) {
                    return ch.children.stream().filter(ech -> !ech.equals(this));
                }
                return Stream.of(ch);
            });
        }

        boolean hasMoreThanOnePathTo(Node<X> given, Set<X> exclude) {
            ArrayDeque<Node> queue = new ArrayDeque<Node>();
            HashSet<X> visited = new HashSet<X>();
            int res = 0;
            Iterator firstLevelChildren = given.childrenWithEquivalents().iterator();
            while (firstLevelChildren.hasNext()) {
                Node child = (Node)firstLevelChildren.next();
                if (exclude.contains(child.node)) continue;
                if (child.node.equals(this.node)) {
                    ++res;
                    continue;
                }
                queue.add(child);
            }
            while (!queue.isEmpty()) {
                Node next = (Node)queue.removeFirst();
                if (exclude.contains(next.node) || next.node.equals(given.node)) continue;
                if (next.node.equals(this.node) && ++res > 1) {
                    return true;
                }
                if (!visited.add(next.node)) continue;
                next.childrenWithEquivalents().forEach(queue::add);
            }
            return false;
        }

        Set<X> equivalents() {
            ArrayDeque<Node> queue = new ArrayDeque<Node>();
            queue.add(this);
            HashSet<X> visited = new HashSet<X>();
            HashMap<Resource, Set> paths = new HashMap<Resource, Set>();
            HashSet res = new HashSet();
            while (!queue.isEmpty()) {
                Node next = (Node)queue.removeFirst();
                Set nextPaths = paths.computeIfAbsent((Resource)next.node, it -> new HashSet());
                if (!nextPaths.isEmpty() && next.node.equals(this.node)) {
                    res.addAll(nextPaths);
                    nextPaths.forEach(p -> {
                        Set other = (Set)paths.get(p);
                        if (other != null) {
                            res.addAll(other);
                        }
                    });
                    continue;
                }
                if (!visited.add(next.node)) continue;
                next.children.forEach(child -> {
                    Set childPaths = paths.computeIfAbsent((Resource)child.node, it -> new HashSet());
                    childPaths.add(next.node);
                    childPaths.addAll(nextPaths);
                    queue.add((Node)child);
                });
            }
            return res;
        }

        public String toString() {
            return this.node.asNode().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            return this.node.equals(((Node)o).node);
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

