/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.type;

import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emfcloud.jackson.databind.type.EcoreType;
import org.eclipse.emfcloud.jackson.databind.type.FeatureKind;

public class EcoreTypeFactory {
    private final Map<Pair<EClass, EStructuralFeature>, JavaType> cache = new WeakHashMap<Pair<EClass, EStructuralFeature>, JavaType>();

    public JavaType typeOf(DatabindContext ctxt, EClass type, EStructuralFeature feature) {
        Pair<EClass, EStructuralFeature> pair = Pair.of(type, feature);
        if (this.cache.containsKey(pair)) {
            return this.cache.get(pair);
        }
        EGenericType genericType = type.getFeatureType(feature);
        EClassifier realType = genericType.getERawType();
        JavaType javaType = realType != null ? this.typeOf(ctxt.getTypeFactory(), FeatureKind.get((ETypedElement)feature), realType) : null;
        if (javaType != null) {
            this.cache.put(pair, javaType);
        }
        return javaType;
    }

    private JavaType typeOf(TypeFactory factory, FeatureKind kind, EClassifier type) {
        switch (kind) {
            case SINGLE_REFERENCE: {
                return this.constructReferenceType(factory, type);
            }
            case MANY_ATTRIBUTE: 
            case MANY_CONTAINMENT: {
                return this.constructCollectionType(factory, this.constructSimpleType(factory, type));
            }
            case MANY_REFERENCE: {
                return this.constructCollectionType(factory, this.constructReferenceType(factory, type));
            }
            case MAP: {
                return this.constructMapType(factory, (EClass)type);
            }
        }
        return this.constructSimpleType(factory, type);
    }

    JavaType constructSimpleType(TypeFactory factory, EClassifier type) {
        return factory.constructType(this.rawType(type));
    }

    JavaType constructReferenceType(TypeFactory factory, EClassifier type) {
        Class<?> rawType = this.rawType(type);
        return factory.constructReferenceType(EcoreType.ReferenceType.class, factory.constructType(rawType));
    }

    JavaType constructCollectionType(TypeFactory factory, JavaType type) {
        return factory.constructCollectionType(Collection.class, type);
    }

    JavaType constructMapType(TypeFactory factory, EClass type) {
        EStructuralFeature key = type.getEStructuralFeature("key");
        EStructuralFeature value = type.getEStructuralFeature("value");
        if (key == null || value == null) {
            return null;
        }
        EClassifier keyType = key.getEType();
        EClassifier valueType = value.getEType();
        Class<?> keyClass = this.rawType(keyType);
        if (String.class.isAssignableFrom(keyClass)) {
            return factory.constructMapLikeType(EMap.class, keyClass, this.rawType(valueType));
        }
        return factory.constructCollectionType(Collection.class, factory.constructType(EObject.class));
    }

    private Class<?> rawType(EClassifier classifier) {
        Class<EcoreType.DataType> rawType = classifier.getInstanceClass();
        if (classifier instanceof EDataType) {
            if (rawType == null || classifier == EcorePackage.Literals.EJAVA_CLASS || classifier == EcorePackage.Literals.EJAVA_OBJECT) {
                rawType = EcoreType.DataType.class;
            } else if (rawType.isArray()) {
                rawType = EcoreType.DataType.class;
            }
        } else if (rawType == null) {
            rawType = EObject.class;
        }
        return rawType;
    }

    private static class Pair<A, B> {
        private final A a;
        private final B b;

        Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.a, pair.a) && Objects.equals(this.b, pair.b);
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        public static <A, B> Pair<A, B> of(A a, B b) {
            return new Pair<A, B>(a, b);
        }
    }
}

