/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.adapters.GraphAdapters;

public final class EndLabelSorter
implements ILayoutProcessor<LGraph> {
    private static final Comparator<LabelGroup> LABEL_GROUP_COMPARATOR = new Comparator<LabelGroup>(){

        @Override
        public int compare(LabelGroup group1, LabelGroup group2) {
            int sourcePortDiff = Integer.compare(group1.edge.getSource().id, group2.edge.getSource().id);
            if (sourcePortDiff != 0) {
                return sourcePortDiff;
            }
            int targetNodeDiff = Integer.compare(group1.edge.getTarget().getNode().id, group2.edge.getTarget().getNode().id);
            if (targetNodeDiff != 0) {
                return targetNodeDiff;
            }
            return Integer.compare(group2.edge.getTarget().id, group1.edge.getTarget().id);
        }
    };

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Sort end labels", 1.0f);
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(node -> node.getType() == LNode.NodeType.NORMAL).forEach(node -> this.processNode((LNode)((Object)node)));
        monitor.done();
    }

    private void processNode(LNode node) {
        boolean initializeMethodCalled = false;
        if (node.hasProperty(InternalProperties.END_LABELS)) {
            Map labelCellMap = (Map)node.getProperty(InternalProperties.END_LABELS);
            for (LPort port : node.getPorts()) {
                if (!this.needsSorting(port)) continue;
                if (!initializeMethodCalled) {
                    this.initialize(node.getGraph());
                    initializeMethodCalled = true;
                }
                this.sort(port, (LabelCell)labelCellMap.get((Object)port));
            }
        }
    }

    private boolean needsSorting(LPort port) {
        int edgesWithEndLabels = 0;
        for (LEdge inEdge : port.getIncomingEdges()) {
            boolean headLabels = inEdge.getLabels().stream().anyMatch(label -> label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.HEAD);
            if (!headLabels) continue;
            ++edgesWithEndLabels;
        }
        for (LEdge outEdge : port.getOutgoingEdges()) {
            boolean tailLabels = outEdge.getLabels().stream().anyMatch(label -> label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.TAIL);
            if (!tailLabels) continue;
            ++edgesWithEndLabels;
        }
        return edgesWithEndLabels >= 2;
    }

    private void initialize(LGraph lGraph) {
        int nextElementID = 0;
        for (Layer layer : lGraph) {
            for (LNode node : layer) {
                node.id = nextElementID++;
                for (LPort port : node.getPorts()) {
                    port.id = nextElementID++;
                }
            }
        }
    }

    private void sort(LPort port, LabelCell portLabelCell) {
        List<LabelGroup> labelGroups = this.createLabelGroups(portLabelCell);
        labelGroups.sort(LABEL_GROUP_COMPARATOR);
        List portLabelCellLabels = portLabelCell.getLabels();
        portLabelCellLabels.clear();
        for (LabelGroup group : labelGroups) {
            portLabelCellLabels.addAll(group.labels);
        }
    }

    private List<LabelGroup> createLabelGroups(LabelCell portLabelCell) {
        HashMap<LEdge, LabelGroup> edgeToGroupMap = new HashMap<LEdge, LabelGroup>();
        for (GraphAdapters.LabelAdapter label : portLabelCell.getLabels()) {
            LEdge edge = (LEdge)((Object)label.getProperty(InternalProperties.END_LABEL_EDGE));
            if (!edgeToGroupMap.containsKey((Object)edge)) {
                edgeToGroupMap.put(edge, new LabelGroup(edge));
            }
            ((LabelGroup)edgeToGroupMap.get((Object)((Object)edge))).labels.add(label);
        }
        return new ArrayList<LabelGroup>(edgeToGroupMap.values());
    }

    private static class LabelGroup {
        private final LEdge edge;
        private final List<GraphAdapters.LabelAdapter<?>> labels = new ArrayList();

        LabelGroup(LEdge edge) {
            this.labels.addAll(this.labels);
            this.edge = edge;
        }
    }
}

