/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.slf4j;

import javax.inject.Provider;
import org.eclipse.fx.core.RankedService;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JLoggerFactory
implements org.eclipse.fx.core.log.LoggerFactory,
Provider<org.eclipse.fx.core.log.LoggerFactory>,
RankedService {
    public int getRanking() {
        return 1;
    }

    public org.eclipse.fx.core.log.LoggerFactory get() {
        return this;
    }

    public @NonNull org.eclipse.fx.core.log.Logger createLogger(@NonNull String name) {
        return new LoggerImpl(name);
    }

    static class LoggerImpl
    implements org.eclipse.fx.core.log.Logger {
        private Logger logger;
        private String name;

        public LoggerImpl(@NonNull String name) {
            this.name = name;
        }

        private Logger getLogger() {
            if (this.logger == null) {
                this.logger = LoggerFactory.getLogger((String)this.name);
            }
            return this.logger;
        }

        public void log(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Logger.Level level, @NonNull String message) {
            switch (level) {
                case TRACE: {
                    this.getLogger().trace(message);
                    break;
                }
                case DEBUG: {
                    this.getLogger().debug(message);
                    break;
                }
                case INFO: {
                    this.getLogger().info(message);
                    break;
                }
                case WARNING: {
                    this.getLogger().warn(message);
                    break;
                }
                case ERROR: 
                case FATAL: {
                    this.getLogger().error(message);
                }
            }
        }

        public void log(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Logger.Level level, @NonNull String message, @NonNull Throwable t) {
            switch (level) {
                case TRACE: {
                    this.getLogger().trace(message, t);
                    break;
                }
                case DEBUG: {
                    this.getLogger().debug(message, t);
                    break;
                }
                case INFO: {
                    this.getLogger().info(message, t);
                    break;
                }
                case WARNING: {
                    this.getLogger().warn(message, t);
                    break;
                }
                case ERROR: 
                case FATAL: {
                    this.getLogger().error(message, t);
                }
            }
        }

        public void logf(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Logger.Level level, @NonNull String pattern, Object ... args) {
            if (this.isEnabled(level)) {
                this.log(level, String.format(pattern, args));
            }
        }

        public void logf(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Logger.Level level, @NonNull String pattern, @NonNull Throwable t, Object ... args) {
            if (this.isEnabled(level)) {
                this.log(level, String.format(pattern, args), t);
            }
        }

        public void trace(@NonNull String message) {
            this.log(Logger.Level.TRACE, message);
        }

        public void debug(@NonNull String message) {
            this.log(Logger.Level.DEBUG, message);
        }

        public void info(@NonNull String message) {
            this.log(Logger.Level.INFO, message);
        }

        public void warning(@NonNull String message) {
            this.log(Logger.Level.WARNING, message);
        }

        public void error(@NonNull String message) {
            this.log(Logger.Level.ERROR, message);
        }

        public void fatal(@NonNull String message) {
            this.log(Logger.Level.FATAL, message);
        }

        public void trace(@NonNull String message, @NonNull Throwable t) {
            this.log(Logger.Level.TRACE, message, t);
        }

        public void debug(@NonNull String message, @NonNull Throwable t) {
            this.log(Logger.Level.DEBUG, message, t);
        }

        public void info(@NonNull String message, @NonNull Throwable t) {
            this.log(Logger.Level.INFO, message, t);
        }

        public void warning(@NonNull String message, @NonNull Throwable t) {
            this.log(Logger.Level.WARNING, message, t);
        }

        public void error(@NonNull String message, @NonNull Throwable t) {
            this.log(Logger.Level.ERROR, message, t);
        }

        public void fatal(@NonNull String message, @NonNull Throwable t) {
            this.log(Logger.Level.FATAL, message, t);
        }

        public void tracef(String pattern, Object ... args) {
            this.logf(Logger.Level.TRACE, pattern, args);
        }

        public void debugf(@NonNull String pattern, Object ... args) {
            this.logf(Logger.Level.DEBUG, pattern, args);
        }

        public void infof(@NonNull String pattern, Object ... args) {
            this.logf(Logger.Level.INFO, pattern, args);
        }

        public void warningf(@NonNull String pattern, Object ... args) {
            this.logf(Logger.Level.WARNING, pattern, args);
        }

        public void errorf(@NonNull String pattern, Object ... args) {
            this.logf(Logger.Level.ERROR, pattern, args);
        }

        public void fatalf(@NonNull String pattern, Object ... args) {
            this.logf(Logger.Level.FATAL, pattern, args);
        }

        public void tracef(@NonNull String pattern, @NonNull Throwable t, Object ... args) {
            this.logf(Logger.Level.TRACE, pattern, t, args);
        }

        public void debugf(@NonNull String pattern, @NonNull Throwable t, Object ... args) {
            this.logf(Logger.Level.DEBUG, pattern, t, args);
        }

        public void infof(@NonNull String pattern, @NonNull Throwable t, Object ... args) {
            this.logf(Logger.Level.INFO, pattern, t, args);
        }

        public void warningf(@NonNull String pattern, @NonNull Throwable t, Object ... args) {
            this.logf(Logger.Level.WARNING, pattern, t, args);
        }

        public void errorf(@NonNull String pattern, @NonNull Throwable t, Object ... args) {
            this.logf(Logger.Level.ERROR, pattern, t, args);
        }

        public void fatalf(@NonNull String pattern, @NonNull Throwable t, Object ... args) {
            this.logf(Logger.Level.FATAL, pattern, t, args);
        }

        public boolean isEnabled(Logger.Level level) {
            switch (level) {
                case TRACE: {
                    return this.getLogger().isTraceEnabled();
                }
                case DEBUG: {
                    return this.getLogger().isDebugEnabled();
                }
                case INFO: {
                    return this.getLogger().isInfoEnabled();
                }
                case WARNING: {
                    return this.getLogger().isWarnEnabled();
                }
                case ERROR: 
                case FATAL: {
                    return this.getLogger().isErrorEnabled();
                }
            }
            return true;
        }
    }
}

