/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.StringPingMessage;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.AnnotatedBinaryClient;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.AnnotatedTextClient;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.AnnotatedThrowingClient;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.MixedProgramaticEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.LinkedListHashSetTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.StringListTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.TypeEnum;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Decoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 0L;
    protected static final String ECHO = "Echo message";
    protected static final String ECHO_PARTIAL = "second part send partially";
    protected static final String ANYTHING = "Anything";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_session11_client_web.war");
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client"});
        archive.addPackage(IOUtil.class.getPackage());
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_session11_client_web");
        this.logExceptionOnInvocation(false);
    }

    @Test
    public void linkedListHashSetTextHandlerTest() throws Exception {
        this.setDecoder(TypeEnum.LINKEDLIST_HASHSET_TEXT, LinkedListHashSetTextDecoder.class);
        this.invoke("echo", ANYTHING, new String[]{"LinkedListHashSetMessageHandler says: ", "Text Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(LinkedList<HashSet<String>>.class, Whole<LinkedList<HashSet<String>>>) works as expected."});
    }

    @Test
    public void textStringBeanHandlerTest() throws Exception {
        this.setDecoder(TypeEnum.STRINGBEAN, StringBeanTextDecoder.class);
        this.invoke("echo", ANYTHING, new String[]{"StringBeanMessageHandler says: ", "Text Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(StringBean.class, Whole<StringBean>) works as expected."});
    }

    @Test
    public void textStreamStringBeanHandlerTest() throws Exception {
        this.setDecoder(TypeEnum.STRINGBEAN, StringBeanTextStreamDecoder.class);
        this.invoke("echo", ANYTHING, new String[]{"StringBeanMessageHandler says: ", "Text Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(StringBean.class, Whole<StringBean>) works as expected."});
    }

    @Test
    public void linkedListTextHandlerTest() throws Exception {
        this.setDecoder(TypeEnum.LIST_TEXT, StringListTextDecoder.class);
        this.invoke("echo", ANYTHING, new String[]{"LinkedListWholeMessageHandler says: ", "Text Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(StringList.class, Whole<StringList>) works as expected."});
    }

    @Test
    public void stringTextHandlerTest() throws Exception {
        this.setDecoder(TypeEnum.STRING_WHOLE, null);
        this.invoke("echo", ANYTHING, new String[]{"StringTextMessageHandler says: ", "Text Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(String.class, Whole<String>) works as expected."});
    }

    @Test
    public void readerMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.READER, null, ECHO);
        this.invoke("echo", ANYTHING, new String[]{"ReaderMessageHandler says: ", "Text Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(Reader.class, Whole<Reader>) works as expected."});
    }

    @Test
    public void pongMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.PONG, null, new StringPingMessage(ECHO));
        this.invoke("echo", ANYTHING, new String[]{"PongMessageHandler says: ", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(PongMessage.class, Whole<PongMessage>) works as expected."});
    }

    @Test
    public void byteBufferMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.BYTEBUFFER_WHOLE, null, ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke("binecho", ANYTHING, new String[]{"ByteBufferMessageHandler says: ", "Binary Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(ByteBuffer.class, Whole<ByteBuffer>) works as expected."});
    }

    @Test
    public void byteArrayMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.BYTEARRAY_WHOLE, null, new Object[]{ECHO.getBytes()});
        this.invoke("binecho", ANYTHING, new String[]{"ByteArrayMessageHandler says: ", "Binary Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(byte[].class, Whole<byte[]>) works as expected."});
    }

    @Test
    public void inputStreamMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.INPUTSTREAM, null, ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke("binecho", ANYTHING, new String[]{"InputStreamMessageHandler says: ", "Binary Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(InputStream.class, Whole<InputStream>) works as expected."});
    }

    @Test
    public void binaryStringBeanMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.STRINGBEAN, StringBeanBinaryDecoder.class, ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke("binecho", ANYTHING, new String[]{"StringBeanMessageHandler says: ", "Binary Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(StringBean.class, Whole<StringBean>) works as expected."});
    }

    @Test
    public void binaryStreamStringBeanMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.STRINGBEAN, StringBeanBinaryStreamDecoder.class, ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke("binecho", ANYTHING, new String[]{"StringBeanMessageHandler says: ", "Binary Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(StringBean.class, Whole<StringBean>) works as expected."});
    }

    @Test
    public void stringPartialHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.STRING_PARTIAL, null, ECHO, ECHO_PARTIAL);
        this.invoke("echo", ANYTHING, new String[]{"StringPartialMessageHandler says: ", "Text Server says:", ECHO, ECHO_PARTIAL});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(String.class, Partial<String>) works as expected."});
    }

    @Test
    public void byteBufferPartialMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.BYTEBUFFER_PARTIAL, null, ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(ECHO_PARTIAL.getBytes()));
        this.invoke("binecho", ANYTHING, new String[]{"ByteBufferPartialMessageHandler says: ", "Binary Server says:", ECHO, ECHO_PARTIAL});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(ByteBuffer.class, Partial<ByteBuffer>) works as expected."});
    }

    @Test
    public void byteArrayPartialMessageHandlerTest() throws Exception {
        this.setDecoderAndEntity(TypeEnum.BYTEARRAY_PARTIAL, null, ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(ECHO_PARTIAL.getBytes()));
        this.invoke("binecho", ANYTHING, new String[]{"ByteArrayPartialMessageHandler says: ", "Binary Server says:", ECHO, ECHO_PARTIAL});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(byte[].class, Partial<byte[]>) works as expected."});
    }

    @Test
    public void annotatedTextReaderClientTest() throws Exception {
        this.setAnnotatedClientEndpointInstance(new AnnotatedTextClient());
        this.invoke("echo", ECHO, new String[]{"ReaderMessageHandler says: ", "Reader decoder", "Text Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(Reader.class, Whole<Reader>) works as expected."});
    }

    @Test
    public void annotatedBinaryInputStreamClientTest() throws Exception {
        this.setAnnotatedClientEndpointInstance(new AnnotatedBinaryClient());
        this.invoke("binecho", ByteBuffer.wrap(ECHO.getBytes()), new String[]{"InputStreamMessageHandler says: ", "InputStream decoder", "Binary Server says:", ECHO});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(InputStream.class, Whole<InputStream>) works as expected."});
    }

    @Test
    public void twiceAddMessageHandlerReaderThrowsExceptionTest() throws Exception {
        AnnotatedThrowingClient client = new AnnotatedThrowingClient(TypeEnum.READER);
        this.setAnnotatedClientEndpointInstance(client);
        this.invoke("echo", ECHO, new String[]{"ReaderMessageHandler says: ", "Text Server says:", ECHO});
        WSCClientIT.assertNotNull((Object)client.getThrown(), (Object[])new Object[]{"there is no exception thrown when adding MessageHandler twice"});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(Reader.class, Whole<Reader>) throws RuntimeException as expected when called twice:", client.getThrown().getMessage()});
    }

    @Test
    public void twiceAddMessageHandlerInputStreamThrowsExceptionTest() throws Exception {
        AnnotatedThrowingClient client = new AnnotatedThrowingClient(TypeEnum.INPUTSTREAM);
        this.setAnnotatedClientEndpointInstance(client);
        this.invoke("binecho", ByteBuffer.wrap(ECHO.getBytes()), new String[]{"InputStreamMessageHandler says: ", "Binary Server says:", ECHO});
        WSCClientIT.assertNotNull((Object)client.getThrown(), (Object[])new Object[]{"there is no exception thrown when adding MessageHandler twice"});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(InputStream.class, Whole<InpuStream>) throws RuntimeException as expected when called twice:", client.getThrown().getMessage()});
    }

    @Test
    public void twiceAddMessageHandlerPongMessageThrowsExceptionTest() throws Exception {
        AnnotatedThrowingClient client = new AnnotatedThrowingClient(TypeEnum.PONG);
        this.setAnnotatedClientEndpointInstance(client);
        this.invoke("echo", new StringPingMessage(ECHO), new String[]{"PongMessageHandler says: ", ECHO});
        WSCClientIT.assertNotNull((Object)client.getThrown(), (Object[])new Object[]{"there is no exception thrown when adding MessageHandler twice"});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(PongMessage.class, Whole<PongMessage>) throws RuntimeException as expected when called twice:", client.getThrown().getMessage()});
    }

    @Test
    public void twiceAddMessageHandlerPartialStringThrowsExceptionTest() throws Exception {
        AnnotatedThrowingClient client = new AnnotatedThrowingClient(TypeEnum.STRING_PARTIAL);
        this.setAnnotatedClientEndpointInstance(client);
        this.setEntity(new Object[]{ECHO, ECHO_PARTIAL});
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "StringPartialMessageHandler says: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "Text Server says:");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO_PARTIAL);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"echo"}));
        this.invoke();
        WSCClientIT.assertNotNull((Object)client.getThrown(), (Object[])new Object[]{"there is no exception thrown when adding MessageHandler twice"});
        WSCClientIT.logMsg((Object[])new Object[]{"addMessageHandler(String.class, Partial<String>) throws RuntimeException as expected when called twice:", client.getThrown().getMessage()});
    }

    protected void setDecoder(TypeEnum type, Class<? extends Decoder> decoderClass) {
        this.setDecoderAndEntity(type, decoderClass, ECHO);
    }

    protected void setDecoderAndEntity(TypeEnum type, Class<? extends Decoder> decoderClass, Object ... entity) {
        this.setEntity(entity);
        MixedProgramaticEndpoint endpoint = new MixedProgramaticEndpoint(type, this.entity);
        this.setClientEndpointInstance(endpoint);
        LinkedList<Class<? extends Decoder>> list = new LinkedList<Class<? extends Decoder>>();
        if (decoderClass != null) {
            list.add(decoderClass);
        }
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().decoders(list).build();
        this.setClientEndpointConfig(config);
    }
}

