/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/srv")
public class WSCServer {
    private static final System.Logger logger = System.getLogger(WSCServer.class.getName());
    private State state = State.INIT;

    @OnOpen
    public void onOpen(final Session session) {
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

            public void onMessage(ByteBuffer message) {
                WSCServer.this.echo(IOUtil.byteBufferToString((ByteBuffer)message), session);
            }
        });
    }

    @OnMessage
    public void echo(String echo, Session session) {
        switch (this.state) {
            case INIT: {
                this.state = State.SECOND;
                this.op(echo, session);
                break;
            }
            case SECOND: {
                this.state = State.FINAL;
                this.op(echo, session);
                break;
            }
            case FINAL: {
                try {
                    session.close();
                    break;
                }
                catch (IOException e) {
                    this.onError(session, e);
                }
            }
        }
    }

    private void op(String echo, Session session) {
        try {
            session.getBasicRemote().sendText(echo);
        }
        catch (IOException e) {
            this.onError(session, e);
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        logger.log(System.Logger.Level.INFO, "@OnError in" + this.getClass().getName());
        t.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)t);
        try {
            if (session.isOpen()) {
                session.getBasicRemote().sendText(message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum State {
        INIT,
        SECOND,
        FINAL;

    }
}

