/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import java.io.IOException;
import java.io.Writer;

public final class FastStringWriter
extends Writer {
    private StringBuilder builder;

    public FastStringWriter() {
        this.builder = new StringBuilder();
    }

    public FastStringWriter(int initialCapacity) throws IllegalArgumentException {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.builder = new StringBuilder(initialCapacity);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.builder.append(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void write(String str) {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        this.builder.append(str.substring(off, off + len));
    }

    public StringBuilder getBuffer() {
        return this.builder;
    }

    public String toString() {
        return this.builder.toString();
    }
}

