/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class URLBuilder {
    private static final Logger log = Logger.getLogger(URLBuilder.class.getCanonicalName());
    private final URL baseURL;
    private final ArrayList<String> paths;
    private final LinkedHashMap<String, String> queries;

    private URLBuilder(URL baseURL, ArrayList<String> paths, LinkedHashMap<String, String> queries) {
        this.baseURL = baseURL;
        this.paths = paths;
        this.queries = queries;
    }

    public static URLBuilder fromURL(URL url) {
        URL baseURL;
        log.finer("Entering URLBuilder.fromURL(" + url.toString() + ")");
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(url.getPath().split("/")));
        LinkedHashMap<String, String> queries = new LinkedHashMap<String, String>();
        while (paths.remove("")) {
        }
        String strQueries = url.getQuery();
        if (strQueries != null) {
            for (String query : strQueries.split("&")) {
                String[] keyValue = query.split("=");
                if (keyValue.length != 2) continue;
                queries.put(keyValue[0], keyValue[1]);
            }
        }
        try {
            baseURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), "");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create a baseURL", e);
        }
        URLBuilder result = new URLBuilder(baseURL, paths, queries);
        log.finer("Exiting URLBuilder.fromURL " + result.toString());
        return result;
    }

    public URLBuilder withPath(String ... paths) {
        this.paths.addAll(Arrays.asList(paths));
        return this;
    }

    public URLBuilder withQuery(String key, String value) {
        this.queries.put(key, value);
        return this;
    }

    public URL build() {
        URL extendedURL = this.baseURL;
        extendedURL = URLBuilder.extendQuery(extendedURL, this.queries);
        extendedURL = this.extendPath(extendedURL, this.paths);
        log.info("Built URL: " + extendedURL.toString());
        return extendedURL;
    }

    private static URL extendQuery(URL baseURL, Map<String, String> queries) {
        if (queries == null) {
            return baseURL;
        }
        Object extendedQuery = baseURL.getQuery() != null ? "?" + baseURL.getQuery() : "?";
        for (Map.Entry<String, String> entry : queries.entrySet()) {
            extendedQuery = (String)extendedQuery + entry.getKey() + "=" + entry.getValue() + "&";
        }
        extendedQuery = ((String)extendedQuery).substring(0, ((String)extendedQuery).length() - 1);
        try {
            return new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), baseURL.getPath() + (String)extendedQuery, null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private URL extendPath(URL baseURL, List<String> paths) {
        if (paths == null) {
            return baseURL;
        }
        Object extendedPath = baseURL.getPath().isBlank() ? "/" : baseURL.getPath();
        for (String pathPart : paths) {
            pathPart = pathPart.replace("/", "");
            extendedPath = (String)extendedPath + pathPart + "/";
        }
        if (((String)extendedPath).lastIndexOf("/") == ((String)extendedPath).length() - 1) {
            extendedPath = ((String)extendedPath).substring(0, ((String)extendedPath).length() - 1);
        }
        try {
            return new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), (String)extendedPath + (String)(baseURL.getQuery() == null ? "" : "?" + baseURL.getQuery()), null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("URLBuilder: ");
        builder.append(" baseURL:[" + this.baseURL.toString() + "]");
        builder.append(", Paths:" + this.paths.toString());
        builder.append(", Queries: {");
        for (String key : this.queries.keySet()) {
            builder.append("[" + key + ", " + this.queries.get(key) + "]");
        }
        builder.append("}");
        return builder.toString();
    }
}

