/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.renderer.fx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.controls.fx.util.ECPTextFieldToModelUpdateValueStrategy;
import org.eclipse.emf.ecp.view.model.internal.fx.SimpleControlRendererFX;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;

public class TextRendererFX
extends SimpleControlRendererFX {
    protected Node createControl() {
        final VControl control = (VControl)this.getVElement();
        final TextField text = new TextField();
        text.setEditable(!control.isReadonly());
        IObservableValue targetValue = this.getTargetObservable(text, "text");
        IObservableValue modelValue = this.getModelObservable((EStructuralFeature.Setting)control.getDomainModelReference().getIterator().next());
        final Binding binding = this.bindModelToTarget(targetValue, modelValue, this.getTargetToModelStrategy(control), this.getModelToTargetStrategy(control));
        text.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    binding.updateTargetToModel();
                }
            }
        });
        control.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                if (msg.getFeature() == VViewPackage.eINSTANCE.getElement_Diagnostic()) {
                    TextRendererFX.this.applyValidation(control, (Node)text);
                }
            }
        });
        this.applyValidation(control, (Node)text);
        text.setMaxWidth(Double.MAX_VALUE);
        return text;
    }

    protected UpdateValueStrategy getModelToTargetStrategy(VControl control) {
        return new EMFUpdateValueStrategy();
    }

    protected UpdateValueStrategy getTargetToModelStrategy(VControl control) {
        return new ECPTextFieldToModelUpdateValueStrategy();
    }
}

