/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.classloader.EaseClassLoader;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;

public class EngineDescription {
    private static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    private static final String BINDING = "binding";
    private static final String TYPE = "scriptType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private final IConfigurationElement fConfigurationElement;
    private List<ScriptType> fTypes = null;

    public EngineDescription(IConfigurationElement configurationElement) {
        this.fConfigurationElement = configurationElement;
    }

    public List<ScriptType> getSupportedScriptTypes() {
        if (this.fTypes == null) {
            this.fTypes = new ArrayList<ScriptType>();
            IScriptService scriptService = ScriptService.getService();
            IConfigurationElement[] iConfigurationElementArray = this.fConfigurationElement.getChildren(BINDING);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String scriptTypeID = child.getAttribute(TYPE);
                if (scriptTypeID != null) {
                    ScriptType scriptType = scriptService.getAvailableScriptTypes().get(scriptTypeID);
                    if (scriptType == null) {
                        Logger.error("org.eclipse.ease", "Unknow scriptType " + scriptTypeID);
                    } else {
                        this.fTypes.add(scriptType);
                    }
                }
                ++n2;
            }
        }
        return this.fTypes;
    }

    public int getPriority() {
        try {
            return Integer.parseInt(this.fConfigurationElement.getAttribute(PRIORITY));
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public IScriptEngine createInstance() throws CoreException {
        Object object = this.fConfigurationElement.createExecutableExtension(CLASS);
        if (object instanceof IScriptEngine) {
            return (IScriptEngine)object;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ease", "Engine implementation is corrupt: " + this.getID()));
    }

    public IScriptEngine createEngine() {
        return ScriptService.getService().createEngine(this);
    }

    public String getID() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public String getName() {
        String name = this.fConfigurationElement.getAttribute(NAME);
        return name != null ? name : this.getID();
    }

    public boolean supports(String scriptType) {
        for (ScriptType type : this.getSupportedScriptTypes()) {
            if (!type.getName().equals(scriptType)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean supports(IFile file) {
        try {
            fileContentType = file.getContentDescription().getContentType();
            var4_4 = this.getSupportedScriptTypes().iterator();
            block2: while (true) {
                if (!var4_4.hasNext()) {
                    return false;
                }
                type = var4_4.next();
                var6_9 = type.getContentTypes().iterator();
                do {
                    if (!var6_9.hasNext()) continue block2;
                } while (!(contentType = var6_9.next()).equals(fileContentType.getId()));
                break;
            }
            return true;
        }
        catch (CoreException e) {
            ** for (type : this.getSupportedScriptTypes())
        }
lbl-1000:
        // 1 sources

        {
            if (!file.getFileExtension().equalsIgnoreCase(type.getDefaultExtension())) continue;
            return true;
        }
lbl17:
        // 1 sources

        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean supportsDebugging() {
        return IDebugEngine.class.isAssignableFrom(this.getEngineClass());
    }

    public boolean isReplShell() {
        return IReplEngine.class.isAssignableFrom(this.getEngineClass());
    }

    private Class<?> getEngineClass() {
        try {
            String className = this.fConfigurationElement.getAttribute(CLASS);
            return new EaseClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return ScriptService.getService().createEngine(this).getClass();
        }
    }
}

