/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.AbstractScriptDebugger;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugFrame;
import org.eclipse.ease.lang.javascript.rhino.RhinoScriptEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebugger
extends AbstractScriptDebugger
implements Debugger {
    private final Map<Integer, Script> fFrameToSource = new HashMap<Integer, Script>();
    private Script fLastScript = null;

    public RhinoDebugger(IScriptEngine engine, boolean showDynamicCode) {
        super(engine, showDynamicCode);
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        Script script = this.getScript(fnOrScript);
        if (script == null) {
            script = this.fLastScript;
        }
        if (script == null) {
            return null;
        }
        DebuggableScript parentScript = RhinoDebugger.getParentScript(fnOrScript);
        if (!this.fFrameToSource.containsKey(parentScript.hashCode())) {
            this.fFrameToSource.put(parentScript.hashCode(), script);
        }
        RhinoDebugFrame debugFrame = new RhinoDebugFrame(fnOrScript);
        this.getStacktrace().add(0, debugFrame);
        return debugFrame;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 3: 
            case 5: {
                this.fLastScript = script;
                break;
            }
            case 2: {
                this.fFrameToSource.clear();
                this.fLastScript = null;
                break;
            }
        }
        super.notify(engine, script, status);
    }

    private Script getScript(DebuggableScript rhinoScript) {
        return this.fFrameToSource.get(RhinoDebugger.getParentScript(rhinoScript).hashCode());
    }

    private static DebuggableScript getParentScript(DebuggableScript rhinoScript) {
        while (rhinoScript.getParent() != null) {
            rhinoScript = rhinoScript.getParent();
        }
        return rhinoScript;
    }

    public class RhinoDebugFrame
    extends ScriptDebugFrame
    implements DebugFrame,
    IScriptDebugFrame {
        private final String fFunctionName;
        private Scriptable fScope;

        public RhinoDebugFrame(DebuggableScript fnOrScript) {
            super(RhinoDebugger.this.getScript(fnOrScript), 0, fnOrScript.isFunction() ? 2 : 1);
            this.fFunctionName = fnOrScript.getFunctionName();
        }

        public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
            this.fScope = activation;
        }

        public void onLineChange(Context cx, int lineNumber) {
            this.setLineNumber(lineNumber);
            if (RhinoDebugger.this.isTrackedScript(this.getScript())) {
                RhinoDebugger.this.processLine(this.getScript(), lineNumber);
            }
        }

        public void onExceptionThrown(Context cx, Throwable ex) {
            RhinoDebugger.this.setExceptionStacktrace();
            this.fScope = null;
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            RhinoDebugger.this.getStacktrace().remove((Object)this);
            this.fScope = null;
        }

        public void onDebuggerStatement(Context cx) {
        }

        public String getName() {
            if (this.getType() == 2) {
                String title = this.getScript().getTitle();
                if (title == null) {
                    title = "";
                }
                return String.valueOf(title) + ":" + this.fFunctionName + "()";
            }
            String title = this.getScript().getTitle();
            if (title == null) {
                title = "(Dynamic)";
            }
            return title;
        }

        public Map<String, Object> getVariables() {
            Map result = RhinoScriptEngine.getVariables((Scriptable)this.fScope);
            return result;
        }

        public Map<String, Object> getVariables(Object parent) {
            if (parent instanceof NativeObject) {
                TreeMap<String, Object> children = new TreeMap<String, Object>();
                Object[] objectArray = ((NativeObject)parent).getIds();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    children.put(key.toString(), ((NativeObject)parent).get(key));
                    ++n2;
                }
                return children;
            }
            if (parent instanceof NativeArray) {
                LinkedHashMap<String, Object> children = new LinkedHashMap<String, Object>();
                Object[] objectArray = ((NativeArray)parent).getIds();
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object key = objectArray[n3];
                    children.put("[" + key + "]", ((NativeArray)parent).get(key));
                    ++n3;
                }
                return children;
            }
            return super.getVariables(parent);
        }
    }
}

