/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.ResumedEvent;
import org.eclipse.ease.debugging.events.debugger.StackFramesEvent;
import org.eclipse.ease.debugging.events.debugger.SuspendedEvent;
import org.eclipse.ease.debugging.events.debugger.ThreadTerminatedEvent;
import org.eclipse.ease.debugging.events.model.GetStackFramesRequest;
import org.eclipse.ease.debugging.events.model.ResumeRequest;
import org.eclipse.ease.debugging.events.model.SuspendRequest;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;
import org.eclipse.ease.debugging.model.EaseDebugTarget;

public class EaseDebugThread
extends EaseDebugElement
implements IThread,
IEventProcessor {
    private final Object fThread;
    private final List<EaseDebugStackFrame> fStackFrames = new ArrayList<EaseDebugStackFrame>();

    public EaseDebugThread(EaseDebugTarget target, Object thread) {
        super(target);
        this.fThread = thread;
    }

    public String getName() {
        if (this.fThread instanceof Thread) {
            return "Thread: " + ((Thread)this.fThread).getName();
        }
        return "Thread: " + this.fThread.toString();
    }

    public synchronized IStackFrame[] getStackFrames() {
        if (this.fStackFrames.isEmpty() && this.isSuspended()) {
            this.getDebugTarget().fireDispatchEvent(new GetStackFramesRequest(this.getThread()));
            return new IStackFrame[0];
        }
        return this.fStackFrames.toArray(new IStackFrame[this.fStackFrames.size()]);
    }

    public boolean hasStackFrames() {
        return this.getStackFrames().length > 0;
    }

    public synchronized EaseDebugStackFrame getTopStackFrame() {
        if (this.hasStackFrames()) {
            return this.fStackFrames.get(0);
        }
        return null;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public Object getThread() {
        return this.fThread;
    }

    public synchronized void setStackFrames(List<IScriptDebugFrame> debugFrames) {
        ArrayList<EaseDebugStackFrame> oldStackFrames = new ArrayList<EaseDebugStackFrame>(this.fStackFrames);
        this.fStackFrames.clear();
        for (IScriptDebugFrame debugFrame : debugFrames) {
            EaseDebugStackFrame stackFrame = null;
            for (EaseDebugStackFrame oldStackFrame : oldStackFrames) {
                if (!debugFrame.equals(oldStackFrame.getDebugFrame())) continue;
                stackFrame = oldStackFrame;
                this.fStackFrames.add(stackFrame);
                oldStackFrame.setDirty();
                break;
            }
            if (stackFrame == null) {
                stackFrame = new EaseDebugStackFrame(this, debugFrame);
                this.fStackFrames.add(stackFrame);
                stackFrame.fireCreationEvent();
                continue;
            }
            oldStackFrames.remove((Object)stackFrame);
        }
        for (EaseDebugStackFrame stackFrame : oldStackFrames) {
            stackFrame.fireTerminateEvent();
        }
        this.fireChangeEvent(512);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public synchronized void handleEvent(IDebugEvent event) {
        if (event instanceof SuspendedEvent) {
            this.setStackFrames(this.filterFrames(((SuspendedEvent)event).getDebugFrames()));
            this.setSuspended();
        } else if (event instanceof ResumedEvent) {
            this.setResumed(((ResumedEvent)event).getType());
        } else if (event instanceof StackFramesEvent) {
            this.setStackFrames(this.filterFrames(((StackFramesEvent)event).getDebugFrames()));
            this.fireChangeEvent(512);
        } else if (event instanceof ThreadTerminatedEvent) {
            this.setStackFrames(new ScriptStackTrace());
            this.setState(EaseDebugElement.State.TERMINATED);
            this.fireChangeEvent(512);
        }
    }

    @Override
    public void setDispatcher(EventDispatchJob dispatcher) {
    }

    private List<IScriptDebugFrame> filterFrames(List<IScriptDebugFrame> frames) {
        if (this.getDebugTarget().isShowDynamicCode()) {
            return frames;
        }
        return frames.stream().filter(frame -> frame.getScript() != null && !frame.getScript().isDynamic()).collect(Collectors.toList());
    }

    @Override
    public boolean canTerminate() {
        if (this.getState() != EaseDebugElement.State.TERMINATED && this.getDebugTarget().getProcess().getThreads().length == 1) {
            return this.getDebugTarget().getProcess().canTerminate();
        }
        return false;
    }

    @Override
    public synchronized void terminate() {
        this.getDebugTarget().getProcess().terminate();
    }

    @Override
    public boolean isTerminated() {
        return this.getState() == EaseDebugElement.State.TERMINATED;
    }

    @Override
    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    @Override
    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    @Override
    public boolean isSuspended() {
        return EaseDebugElement.State.SUSPENDED == this.getState();
    }

    @Override
    public void resume() {
        this.getDebugTarget().fireDispatchEvent(new ResumeRequest(32, this.getThread()));
    }

    @Override
    public void suspend() {
        this.getDebugTarget().fireDispatchEvent(new SuspendRequest(this.getThread()));
    }

    @Override
    public boolean canStepInto() {
        return this.isSuspended();
    }

    @Override
    public boolean canStepOver() {
        return this.isSuspended();
    }

    @Override
    public boolean canStepReturn() {
        return this.isSuspended();
    }

    @Override
    public boolean isStepping() {
        return EaseDebugElement.State.STEPPING == this.getState();
    }

    @Override
    public void stepInto() {
        this.getDebugTarget().fireDispatchEvent(new ResumeRequest(1, this.getThread()));
    }

    @Override
    public void stepOver() {
        this.getDebugTarget().fireDispatchEvent(new ResumeRequest(2, this.getThread()));
    }

    @Override
    public void stepReturn() {
        this.getDebugTarget().fireDispatchEvent(new ResumeRequest(4, this.getThread()));
    }
}

