/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.scripts.repository.IRepositoryPackage;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.ParameterMapImpl;
import org.eclipse.ease.ui.scripts.repository.impl.RawLocationImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ui.PlatformUI;

public class ScriptImpl
extends RawLocationImpl
implements IScript {
    protected static final long TIMESTAMP_EDEFAULT = -1L;
    protected long timestamp = -1L;
    protected EMap<String, String> scriptParameters;
    protected EMap<String, String> userParameters;

    protected ScriptImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return IRepositoryPackage.Literals.SCRIPT;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long newTimestamp) {
        long oldTimestamp = this.timestamp;
        this.timestamp = newTimestamp;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldTimestamp, this.timestamp));
        }
    }

    @Override
    public IScriptLocation getEntry() {
        if (this.eContainerFeatureID() != 3) {
            return null;
        }
        return (IScriptLocation)this.eInternalContainer();
    }

    public NotificationChain basicSetEntry(IScriptLocation newEntry, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newEntry, 3, msgs);
        return msgs;
    }

    @Override
    public void setEntry(IScriptLocation newEntry) {
        if (newEntry != this.eInternalContainer() || this.eContainerFeatureID() != 3 && newEntry != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newEntry)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newEntry != null) {
                msgs = ((InternalEObject)newEntry).eInverseAdd((InternalEObject)this, 4, IScriptLocation.class, msgs);
            }
            if ((msgs = this.basicSetEntry(newEntry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newEntry, (Object)newEntry));
        }
    }

    @Override
    public EMap<String, String> getScriptParameters() {
        if (this.scriptParameters == null) {
            this.scriptParameters = new EcoreEMap(IRepositoryPackage.Literals.PARAMETER_MAP, ParameterMapImpl.class, (InternalEObject)this, 4);
        }
        return this.scriptParameters;
    }

    @Override
    public EMap<String, String> getUserParameters() {
        if (this.userParameters == null) {
            this.userParameters = new EcoreEMap(IRepositoryPackage.Literals.PARAMETER_MAP, ParameterMapImpl.class, (InternalEObject)this, 5);
        }
        return this.userParameters;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetEntry((IScriptLocation)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetEntry(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getScriptParameters()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getUserParameters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 3: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 4, IScriptLocation.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getTimestamp();
            }
            case 3: {
                return this.getEntry();
            }
            case 4: {
                if (coreType) {
                    return this.getScriptParameters();
                }
                return this.getScriptParameters().map();
            }
            case 5: {
                if (coreType) {
                    return this.getUserParameters();
                }
                return this.getUserParameters().map();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setTimestamp((Long)newValue);
                return;
            }
            case 3: {
                this.setEntry((IScriptLocation)newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getScriptParameters()).set(newValue);
                return;
            }
            case 5: {
                ((EStructuralFeature.Setting)this.getUserParameters()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setTimestamp(-1L);
                return;
            }
            case 3: {
                this.setEntry(null);
                return;
            }
            case 4: {
                this.getScriptParameters().clear();
                return;
            }
            case 5: {
                this.getUserParameters().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.timestamp != -1L;
            }
            case 3: {
                return this.getEntry() != null;
            }
            case 4: {
                return this.scriptParameters != null && !this.scriptParameters.isEmpty();
            }
            case 5: {
                return this.userParameters != null && !this.userParameters.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 2: {
                this.run();
                return null;
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getPath();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (timestamp: ");
        result.append(this.timestamp);
        result.append(')');
        return result.toString();
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>(this.getScriptParameters().map());
        parameters.putAll(this.getUserParameters().map());
        return parameters;
    }

    @Override
    public ScriptType getType() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ScriptType type = null;
        String identifier = this.getParameters().get("script-type");
        if (identifier != null) {
            type = (ScriptType)scriptService.getAvailableScriptTypes().get(identifier);
        }
        if (type == null) {
            Object resource = this.getResource();
            if (resource instanceof IFile && ((IFile)resource).exists()) {
                type = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)resource, null));
            } else if (resource instanceof File && ((File)resource).exists()) {
                type = scriptService.getScriptType(resource.toString());
            } else if (resource instanceof URI) {
                type = scriptService.getScriptType(resource.toString());
            }
        }
        return type;
    }

    @Override
    public String getName() {
        return this.getPath().lastSegment();
    }

    @Override
    public IPath getPath() {
        String name = this.getParameters().get("name");
        if (name != null) {
            return new Path(name).makeAbsolute();
        }
        return new Path(this.getLocation().substring(this.getEntry().getLocation().length())).makeAbsolute();
    }

    @Override
    public void run() {
        EngineDescription engineDescription = this.getEngineDescription();
        if (engineDescription != null) {
            IScriptEngine engine = engineDescription.createEngine();
            ScriptConsole console = ScriptConsole.create((String)(String.valueOf(engine.getName()) + ": " + this.getPath()), (IScriptEngine)engine);
            engine.setOutputStream((OutputStream)console.getOutputStream());
            engine.setErrorStream((OutputStream)console.getErrorStream());
            engine.setVariable("argv", (Object)new String[0]);
            engine.executeAsync(this.getResource());
            engine.schedule();
        } else {
            Logger.logError((String)("Could not detect script engine for " + this));
        }
    }

    private EngineDescription getEngineDescription() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        String engineIDs = this.getParameters().get("script-engine");
        if (engineIDs == null) {
            return scriptService.getEngine(this.getType().getName());
        }
        HashSet<String> blacklist = new HashSet<String>();
        String[] stringArray = engineIDs.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            EngineDescription engineDescription = scriptService.getEngineByID(id.trim());
            if (engineDescription != null) {
                return engineDescription;
            }
            if (id.trim().startsWith("!")) {
                blacklist.add(id.trim().substring(1));
            }
            ++n2;
        }
        for (EngineDescription description : scriptService.getEngines(this.getType().getName())) {
            if (blacklist.contains(description.getID())) continue;
            return description;
        }
        return null;
    }
}

