/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.ICompletionProvider;
import org.eclipse.ease.ui.completion.ModuleCompletionProvider;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.dnd.ShellDropTarget;
import org.eclipse.ease.ui.scripts.IScriptSupport;
import org.eclipse.ease.ui.scripts.ui.ScriptComposite;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.Preferences;

public class ScriptShell
extends ViewPart
implements IScriptSupport,
IPropertyChangeListener,
IScriptEngineProvider,
IExecutionListener {
    public static final String VIEW_ID = "org.eclipse.ease.views.scriptShell";
    private static final String XML_HISTORY_NODE = "history";
    private static final int TYPE_ERROR = 1;
    private static final int TYPE_OUTPUT = 2;
    private static final int TYPE_RESULT = 3;
    private static final int TYPE_COMMAND = 4;
    private SashForm fSashForm;
    private Combo fInputCombo;
    private StyledText fOutputText;
    private boolean fScrollLock = false;
    private boolean fPrintLock = false;
    private LocalResourceManager fResourceManager = null;
    private int[] fSashWeights = new int[]{70, 30};
    private IScriptEngine fScriptEngine;
    private IMemento fInitMemento;
    private ScriptComposite fScriptComposite;
    private int fHistoryLength;
    private boolean fAutoFocus;
    private boolean fKeepCommand;
    private AutoFocus fAutoFocusListener = null;
    private ContentProposalAdapter fContentAssistAdapter = null;
    private TabItem fTabScripts;
    private TabItem fTabVariables;
    private Composite fcomposite;
    private Tree ftree;
    private TreeViewer fVariablesTree;

    public ScriptShell() {
        Collection engines;
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        String engineID = prefs.get("shellDefaultEngine", "org.eclipse.ease.javascript.rhino");
        EngineDescription engineDescription = scriptService.getEngineByID(engineID);
        if (engineDescription == null && (engineDescription = scriptService.getEngine("JavaScript")) == null && !(engines = scriptService.getEngines()).isEmpty()) {
            engineDescription = (EngineDescription)engines.iterator().next();
        }
        if (engineDescription != null) {
            this.setEngine(engineDescription.getID());
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public final void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fInitMemento = memento;
    }

    public final void saveState(IMemento memento) {
        String[] stringArray = this.fInputCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            memento.createChild(XML_HISTORY_NODE).putTextData(item);
            ++n2;
        }
        super.saveState(memento);
    }

    public final void createPartControl(Composite parent) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        parent.setLayout((Layout)new GridLayout());
        this.fSashForm = new SashForm(parent, 0);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fOutputText = new StyledText((Composite)this.fSashForm, 2568);
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            this.fOutputText.setFont(this.fResourceManager.createFont(FontDescriptor.createFrom((String)"Courier New", (int)10, (int)0)));
        } else if ("linux".equals(os)) {
            this.fOutputText.setFont(this.fResourceManager.createFont(FontDescriptor.createFrom((String)"Monospace", (int)10, (int)0)));
        }
        this.fOutputText.setEditable(false);
        this.fOutputText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String selected = ScriptShell.this.fOutputText.getLine(ScriptShell.this.fOutputText.getLineIndex(e.y));
                if (!selected.isEmpty()) {
                    ScriptShell.this.fInputCombo.setText(selected);
                    ScriptShell.this.fInputCombo.setFocus();
                    ScriptShell.this.fInputCombo.setSelection(new Point(0, selected.length()));
                }
            }
        });
        TabFolder tabFolder = new TabFolder((Composite)this.fSashForm, 1024);
        this.fTabScripts = new TabItem(tabFolder, 0);
        this.fTabScripts.setText("Scripts");
        this.fScriptComposite = new ScriptComposite(this, this.getSite(), (Composite)tabFolder, 0);
        this.fScriptComposite.setEngine(this.fScriptEngine.getDescription().getID());
        this.fTabScripts.setControl((Control)this.fScriptComposite);
        this.fTabVariables = new TabItem(tabFolder, 0);
        this.fTabVariables.setText("Variables");
        this.fcomposite = new Composite((Composite)tabFolder, 0);
        this.fTabVariables.setControl((Control)this.fcomposite);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.fcomposite.setLayout((Layout)treeColumnLayout);
        this.fVariablesTree = new TreeViewer(this.fcomposite, 2048);
        this.ftree = this.fVariablesTree.getTree();
        this.ftree.setHeaderVisible(true);
        this.ftree.setLinesVisible(true);
        this.fVariablesTree.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !((Map.Entry)element).getKey().toString().startsWith("__MOD_");
            }
        }, new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Object name = ((Map.Entry)element).getKey();
                return !"wait()".equals(name) && !"notify()".equals(name) && !"notifyAll()".equals(name) && !"equals()".equals(name) && !"getClass()".equals(name) && !"hashCode()".equals(name) && !"toString()".equals(name);
            }
        }});
        this.fVariablesTree.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return ((Map.Entry)element).getKey().toString().endsWith("()") ? 2 : 1;
            }
        });
        this.fVariablesTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ScriptShell.this.getScriptEngine().getVariables().entrySet().toArray();
            }

            public Object[] getChildren(Object parentElement) {
                Object parent = ((Map.Entry)parentElement).getValue();
                HashMap<String, Object> children = new HashMap<String, Object>();
                if (!((Map.Entry)parentElement).getKey().toString().endsWith("()")) {
                    AccessibleObject[] accessibleObjectArray = parent.getClass().getFields();
                    int n = accessibleObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = accessibleObjectArray[n2];
                        try {
                            children.put(field.getName(), field.get(parent));
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                    accessibleObjectArray = parent.getClass().getMethods();
                    n = accessibleObjectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        AccessibleObject method = accessibleObjectArray[n2];
                        try {
                            children.put(String.valueOf(((Method)method).getName()) + "()", ((Method)method).getReturnType().getName());
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                }
                return children.entrySet().toArray();
            }
        });
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.fVariablesTree, 0);
        TreeColumn column = treeViewerColumn.getColumn();
        treeColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
        column.setText("Variable");
        treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Map.Entry)element).getKey().toString();
            }

            public Image getImage(Object element) {
                if (((Map.Entry)element).getKey().toString().endsWith("()")) {
                    return Activator.getImage("org.eclipse.wst.jsdt.ui", "/icons/full/obj16/methpub_obj.gif", true);
                }
                return Activator.getImage("org.eclipse.wst.jsdt.ui", "/icons/full/obj16/field_public_obj.gif", true);
            }
        });
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.fVariablesTree, 0);
        TreeColumn column2 = treeViewerColumn2.getColumn();
        treeColumnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(1));
        column2.setText("Content");
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Map.Entry)element).getValue().toString();
            }
        });
        this.fVariablesTree.setInput((Object)this);
        this.fSashForm.setWeights(this.fSashWeights);
        this.fInputCombo = new Combo(parent, 0);
        this.fInputCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String input = ScriptShell.this.fInputCombo.getText();
                ScriptShell.this.fInputCombo.setText("");
                ScriptShell.this.addToHistory(input);
                ScriptShell.this.fScriptEngine.executeAsync((Object)input);
            }
        });
        this.fInputCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.fInitMemento != null) {
            IMemento[] iMementoArray = this.fInitMemento.getChildren(XML_HISTORY_NODE);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if (node.getTextData() != null) {
                    this.fInputCombo.add(node.getTextData());
                }
                ++n2;
            }
        }
        this.addAutoCompletion();
        this.fInitMemento = null;
        ShellDropTarget.addDropSupport((Control)this.fOutputText, this);
        this.setPartName(String.valueOf(this.fScriptEngine.getName()) + " " + super.getTitle());
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        this.fHistoryLength = prefs.getInt("shellHistoryLength", 20);
        this.fAutoFocus = prefs.getBoolean("shellAutoFocus", true);
        this.fKeepCommand = prefs.getBoolean("shellKeepCommand", false);
        if (this.fAutoFocus) {
            if (this.fAutoFocusListener == null) {
                this.fAutoFocusListener = new AutoFocus();
            }
            this.fOutputText.addKeyListener((KeyListener)this.fAutoFocusListener);
        }
        this.runStartupCommands();
    }

    private void addAutoCompletion() {
        ICompletionProvider provider;
        if (this.fContentAssistAdapter != null) {
            this.fContentAssistAdapter.setEnabled(false);
        }
        if ((provider = ModuleCompletionProvider.getCompletionProvider(this.fScriptEngine.getDescription())) != null) {
            try {
                KeyStroke activationKey = KeyStroke.getInstance((String)"Ctrl+Space");
                ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.fInputCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)provider, activationKey, provider.getActivationChars());
                adapter.setProposalAcceptanceStyle(1);
                this.fContentAssistAdapter = adapter;
            }
            catch (ParseException e) {
                Logger.logError((String)"Cannot create content assist", (Throwable)e);
            }
        }
    }

    public void runStartupCommands() {
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        for (ScriptType scriptType : this.fScriptEngine.getDescription().getSupportedScriptTypes()) {
            String initCommands = prefs.get("shellStartup" + scriptType.getName(), "").trim();
            if (initCommands.isEmpty()) continue;
            this.fScriptEngine.executeAsync((Object)initCommands);
        }
    }

    private void addToHistory(String input) {
        if (this.fInputCombo.getSelectionIndex() != -1) {
            this.fInputCombo.remove(this.fInputCombo.getSelectionIndex());
        } else {
            int index = 0;
            while (index < this.fInputCombo.getItemCount()) {
                if (this.fInputCombo.getItem(index).equals(input)) {
                    this.fInputCombo.remove(index);
                    break;
                }
                ++index;
            }
        }
        while (this.fInputCombo.getItemCount() >= this.fHistoryLength) {
            this.fInputCombo.remove(this.fInputCombo.getItemCount() - 1);
        }
        this.fInputCombo.add(input, 0);
    }

    public final void dispose() {
        if (this.fScriptEngine != null) {
            this.fScriptEngine.removeExecutionListener((IExecutionListener)this);
            this.fScriptEngine.terminate();
        }
        this.fResourceManager.dispose();
        super.dispose();
    }

    public final void setFocus() {
        this.fInputCombo.setFocus();
    }

    public final void clearOutput() {
        this.fOutputText.setText("");
        this.fOutputText.setStyleRanges(new StyleRange[0]);
    }

    public final void setScrollLock(boolean lock) {
        this.fScrollLock = lock;
    }

    public final void setPrintLock(boolean lock) {
        this.fPrintLock = lock;
    }

    private void localPrint(final String message, final int style) {
        if (!(message == null || this.fPrintLock && style != 1)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String out = message;
                    if (style != 4) {
                        out = "\t" + message.replaceAll("\\r?\\n", "\n\t");
                    }
                    if (!ScriptShell.this.fOutputText.isDisposed()) {
                        ScriptShell.this.fOutputText.append("\n");
                        StyleRange styleRange = ScriptShell.this.getStyle(style, ScriptShell.this.fOutputText.getText().length(), out.length());
                        ScriptShell.this.fOutputText.append(out);
                        ScriptShell.this.fOutputText.setStyleRange(styleRange);
                        if (!ScriptShell.this.fScrollLock) {
                            ScriptShell.this.fOutputText.setHorizontalPixel(0);
                            ScriptShell.this.fOutputText.setTopPixel(ScriptShell.this.fOutputText.getLineHeight() * ScriptShell.this.fOutputText.getLineCount());
                        }
                    }
                }
            });
        }
    }

    private StyleRange getStyle(int style, int start, int length) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        switch (style) {
            case 3: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(16)));
                break;
            }
            case 4: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(9)));
                styleRange.fontStyle = 1;
                break;
            }
            case 1: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(3)));
                styleRange.fontStyle = 2;
                break;
            }
            case 2: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(2)));
                break;
            }
        }
        return styleRange;
    }

    public final String getSelectedText() {
        String text = this.fOutputText.getSelectionText();
        if (text.isEmpty()) {
            return this.fOutputText.getText();
        }
        return text;
    }

    @Override
    public final void toggleMacroManager() {
        if (this.fSashForm.getWeights()[1] == 0) {
            this.fSashForm.setWeights(this.fSashWeights);
        } else {
            this.fSashWeights = this.fSashForm.getWeights();
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.fSashForm.setWeights(nArray);
        }
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if ("shellAutoFocus".equals(event.getProperty())) {
            if (Boolean.parseBoolean(event.getNewValue().toString())) {
                if (this.fAutoFocusListener == null) {
                    this.fAutoFocusListener = new AutoFocus();
                }
                this.fOutputText.addKeyListener((KeyListener)this.fAutoFocusListener);
            } else {
                this.fOutputText.removeKeyListener((KeyListener)this.fAutoFocusListener);
            }
        } else if ("shellKeepCommand".equals(event.getProperty())) {
            this.fKeepCommand = Boolean.parseBoolean(event.getNewValue().toString());
        } else if ("shellHistoryLength".equals(event.getProperty())) {
            this.fHistoryLength = Integer.parseInt(event.getNewValue().toString());
        }
    }

    public StyledText getOutput() {
        return this.fOutputText;
    }

    public void stopScriptEngine() {
        this.fScriptEngine.terminateCurrent();
    }

    public IScriptEngine getScriptEngine() {
        return this.fScriptEngine;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        try {
            switch (status) {
                case 3: {
                    this.localPrint(script.getCode(), 4);
                    break;
                }
                case 4: {
                    if (script.getResult().hasException()) {
                        this.localPrint(script.getResult().getException().getLocalizedMessage(), 1);
                    } else {
                        Object result = script.getResult().getResult();
                        if (result != null) {
                            this.localPrint(script.getResult().getResult().toString(), 3);
                        } else {
                            this.localPrint("[null]", 3);
                        }
                        if (this.fContentAssistAdapter != null) {
                            ((ICompletionProvider)this.fContentAssistAdapter.getContentProposalProvider()).addCode(script.getCode());
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ScriptShell.this.fVariablesTree.refresh();
                            }
                        });
                    }
                    if (this.fKeepCommand) {
                        final String code = script.getCode();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ScriptShell.this.fInputCombo.isDisposed()) {
                                    ScriptShell.this.fInputCombo.setText(code);
                                    ScriptShell.this.fInputCombo.setSelection(new Point(0, code.length()));
                                }
                            }
                        });
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {}
    }

    public final void setEngine(String id) {
        if (this.fScriptEngine != null) {
            this.fScriptEngine.removeExecutionListener((IExecutionListener)this);
            this.fScriptEngine.terminate();
        }
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        this.fScriptEngine = scriptService.getEngineByID(id).createEngine();
        if (this.fScriptEngine != null) {
            this.fScriptEngine.setTerminateOnIdle(false);
            this.setPartName(String.valueOf(this.fScriptEngine.getName()) + " Script Shell");
            ScriptConsole console = ScriptConsole.create(String.valueOf(this.fScriptEngine.getName()) + "Script Shell", this.fScriptEngine);
            this.fScriptEngine.setOutputStream((OutputStream)console.getOutputStream());
            this.fScriptEngine.setErrorStream((OutputStream)console.getErrorStream());
            this.fScriptEngine.addExecutionListener((IExecutionListener)this);
            if (this.fScriptComposite != null) {
                this.fScriptComposite.setEngine(this.fScriptEngine.getDescription().getID());
            }
            this.fScriptEngine.schedule();
            if (this.fInputCombo != null) {
                this.runStartupCommands();
            }
        }
    }

    private class AutoFocus
    implements KeyListener {
        private AutoFocus() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 118 && (e.stateMask & 0x40000) != 0) {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                Object content = clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (content != null) {
                    ScriptShell.this.fInputCombo.setText(String.valueOf(ScriptShell.this.fInputCombo.getText()) + content.toString());
                }
                ScriptShell.this.fInputCombo.setFocus();
                ScriptShell.this.fInputCombo.setSelection(new Point(ScriptShell.this.fInputCombo.getText().length(), ScriptShell.this.fInputCombo.getText().length()));
            }
        }

        public void keyPressed(KeyEvent e) {
            if ((e.keyCode != 99 || (e.stateMask & 0x40000) == 0) && e.keyCode != 262144) {
                ScriptShell.this.fInputCombo.setText(String.valueOf(ScriptShell.this.fInputCombo.getText()) + e.character);
                ScriptShell.this.fInputCombo.setFocus();
                ScriptShell.this.fInputCombo.setSelection(new Point(ScriptShell.this.fInputCombo.getText().length(), ScriptShell.this.fInputCombo.getText().length()));
            }
        }
    }
}

