/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public final class ShellDropTarget
extends DropTargetAdapter {
    private static final String EXTENSION_DROP_HANDLER_ID = "org.eclipse.ease.ui.dropHandler";
    private static final String DROP_HANDLER = "dropHandler";
    private static final String PARAMETER_CLASS = "class";
    private final IScriptEngineProvider mScriptEngineProvider;

    private static Collection<DropTargetListener> getDropTargetListeners() {
        IConfigurationElement[] config;
        HashSet<DropTargetListener> listeners = new HashSet<DropTargetListener>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_DROP_HANDLER_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getName().equals(DROP_HANDLER)) {
                try {
                    Object executable = e.createExecutableExtension(PARAMETER_CLASS);
                    if (executable instanceof DropTargetListener) {
                        listeners.add((DropTargetListener)executable);
                    }
                }
                catch (CoreException e1) {
                    Logger.logError((String)"Invalid drop taret listener detected", (Throwable)e1);
                }
            }
            ++n2;
        }
        return listeners;
    }

    public static void addDropSupport(Control parent, IScriptEngineProvider engineProvider) {
        DropTarget target = new DropTarget(parent, 3);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance(), LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new ShellDropTarget(engineProvider));
    }

    private ShellDropTarget(IScriptEngineProvider provider) {
        this.mScriptEngineProvider = provider;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 2 || event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
    }

    public void drop(DropTargetEvent event) {
        Collection<DropTargetListener> listeners = ShellDropTarget.getDropTargetListeners();
        if (!listeners.isEmpty()) {
            for (DropTargetListener listener : listeners) {
                try {
                    listener.drop(event);
                    return;
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        if (event.data instanceof IScript[]) {
            IScript[] iScriptArray = (IScript[])event.data;
            int n = iScriptArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScript script = iScriptArray[n2];
                this.execute(script);
                ++n2;
            }
        } else if (event.data instanceof IResource[]) {
            IResource[] iResourceArray = (IResource[])event.data;
            int n = iResourceArray.length;
            int n3 = 0;
            while (n3 < n) {
                IResource resource = iResourceArray[n3];
                this.execute(resource);
                ++n3;
            }
        } else if (event.data instanceof String[]) {
            String[] stringArray = (String[])event.data;
            int n = stringArray.length;
            int n4 = 0;
            while (n4 < n) {
                String path = stringArray[n4];
                this.mScriptEngineProvider.getScriptEngine().executeAsync((Object)("include('file:/" + new Path(path).toString() + "');"));
                ++n4;
            }
        } else if (event.data instanceof String) {
            this.execute(event.data);
        } else if (event.data instanceof Object[]) {
            Object[] objectArray = (Object[])event.data;
            int n = objectArray.length;
            int n5 = 0;
            while (n5 < n) {
                Object object = objectArray[n5];
                this.execute(object);
                ++n5;
            }
        } else if (event.data instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)event.data).toArray();
            int n = objectArray.length;
            int n6 = 0;
            while (n6 < n) {
                Object element = objectArray[n6];
                this.execute(element);
                ++n6;
            }
        } else if (event.data instanceof Object) {
            this.execute(event.data);
        }
    }

    private void execute(Object element) {
        if (element instanceof IResource) {
            this.mScriptEngineProvider.getScriptEngine().executeAsync((Object)("include('workspace:/" + ((IResource)element).getFullPath().toString() + "');"));
        } else if (element instanceof IScript) {
            this.mScriptEngineProvider.getScriptEngine().executeAsync((Object)("include('script:/" + ((IScript)element).getPath() + "');"));
        } else {
            this.mScriptEngineProvider.getScriptEngine().executeAsync(element);
        }
    }
}

