/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.widgets.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dirigible.ide.ui.widgets.connection.IConnectionContentProvider;
import org.eclipse.dirigible.ide.ui.widgets.connection.IConnectionItemResolver;
import org.eclipse.dirigible.ide.ui.widgets.connection.Messages;
import org.eclipse.dirigible.ide.ui.widgets.connection.spline.SplineRenderer;
import org.eclipse.dirigible.ide.ui.widgets.connection.spline.TwoPointSpline;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ConnectionViewer
extends ContentViewer {
    private static final long serialVersionUID = 2227733381272538227L;
    private static final String INVALID_OR_MISSING_TARGET_ITEM_RESOLVER = Messages.ConnectionViewer_INVALID_OR_MISSING_TARGET_ITEM_RESOLVER;
    private static final String INVALID_OR_MISSING_SOURCE_ITEM_RESOLVER = Messages.ConnectionViewer_INVALID_OR_MISSING_SOURCE_ITEM_RESOLVER;
    private static final String INVALID_OR_MISSING_LABEL_PROVIDER = Messages.ConnectionViewer_INVALID_OR_MISSING_LABEL_PROVIDER;
    private static final String INVALID_OR_MISSING_CONTENT_PROVIDER = Messages.ConnectionViewer_INVALID_OR_MISSING_CONTENT_PROVIDER;
    private static final String INVALID_OR_NULL_SELECTION = Messages.ConnectionViewer_INVALID_OR_NULL_SELECTION;
    private static final String CONTENT_PROVIDER_MUST_NOT_RETURN_NULL = Messages.ConnectionViewer_CONTENT_PROVIDER_MUST_NOT_RETURN_NULL;
    private static final String COLOR_CANNOT_BE_NULL = Messages.ConnectionViewer_COLOR_CANNOT_BE_NULL;
    private static final int MARKER_WIDTH = 16;
    private static final int MARKER_HEIGHT = 16;
    private static final int MARKER_MARGIN = 15;
    private static final int DEFAULT_LINE_WIDTH_DEFAULT = 1;
    private static final int DEFAULT_LINE_WIDTH_SELECTED = 2;
    private static final int SPLINE_PRECISION = 20;
    private final SplineRenderer splineRenderer = new SplineRenderer(20);
    private final Canvas canvas;
    private final ListenerList doubleClickListenerList = new ListenerList();
    private IConnectionItemResolver sourceItemResolver = null;
    private IConnectionItemResolver targetItemResolver = null;
    private final Set<Object> selection = new HashSet<Object>();
    private Object[] connections = new Object[0];
    private int lineWidthDefault = 1;
    private int lineWidthSelected = 2;
    private Color colorDefault = Display.getCurrent().getSystemColor(23);
    private Color colorSelected = Display.getCurrent().getSystemColor(26);

    public ConnectionViewer(Composite parent) {
        this.canvas = new Canvas(parent, 0x20000800);
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 7106341036462228033L;

            public void mouseDown(MouseEvent e) {
                ConnectionViewer.this.handleMouseDown(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                ConnectionViewer.this.handleMouseDoubleClick(e);
            }
        });
        this.canvas.addPaintListener(new PaintListener(){
            private static final long serialVersionUID = -4651208476754703341L;

            public void paintControl(PaintEvent event) {
                ConnectionViewer.this.handleCanvasPaint(event.gc);
            }
        });
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListenerList.add((Object)listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListenerList.remove((Object)listener);
    }

    public void setSourceItemResolver(IConnectionItemResolver itemResolver) {
        this.sourceItemResolver = itemResolver;
    }

    public IConnectionItemResolver getSourceItemResolver() {
        return this.sourceItemResolver;
    }

    public void setTargetItemResolver(IConnectionItemResolver itemResolver) {
        this.targetItemResolver = itemResolver;
    }

    public IConnectionItemResolver getTargetItemResolver() {
        return this.targetItemResolver;
    }

    public void setLineColorDefault(Color color) {
        if (color == null) {
            throw new IllegalArgumentException(COLOR_CANNOT_BE_NULL);
        }
        this.colorDefault = color;
        this.refresh();
    }

    public Color getLineColorDefault() {
        return this.colorDefault;
    }

    public void setLineColorSelected(Color color) {
        if (color == null) {
            throw new IllegalArgumentException(COLOR_CANNOT_BE_NULL);
        }
        this.colorSelected = color;
        this.refresh();
    }

    public Color getLineColorSelection() {
        return this.colorSelected;
    }

    public void setLineWidthDefault(int width) {
        this.lineWidthDefault = width;
        this.refresh();
    }

    public int getLineWidthDefault() {
        return this.lineWidthDefault;
    }

    public void setLineWidthSelected(int width) {
        this.lineWidthSelected = width;
        this.refresh();
    }

    public int getLineWidthSelected() {
        return this.lineWidthSelected;
    }

    public Control getControl() {
        return this.canvas;
    }

    public void refresh() {
        this.updateViewModel();
        this.update();
    }

    private void updateViewModel() {
        this.assertContentProvider(this.getContentProvider());
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        Object[] elements = contentProvider.getElements(this.getInput());
        Assert.isNotNull((Object)elements, (String)CONTENT_PROVIDER_MUST_NOT_RETURN_NULL);
        this.connections = elements;
    }

    public void update() {
        if (this.canvas.isVisible()) {
            this.canvas.redraw();
        }
    }

    private void handleMouseDown(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        Object connection = this.getConnectionAtPosition(e.x, e.y);
        if (connection == null) {
            return;
        }
        if ((e.stateMask & 0x40000) > 0) {
            if (this.selection.contains(connection)) {
                this.selection.remove(connection);
            } else {
                this.selection.add(connection);
            }
        } else {
            this.selection.clear();
            this.selection.add(connection);
        }
        StructuredSelection eventSelection = new StructuredSelection(this.selection.toArray());
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)eventSelection));
        this.refresh();
    }

    private void handleMouseDoubleClick(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        Object connection = this.getConnectionAtPosition(e.x, e.y);
        if (connection == null) {
            return;
        }
        this.fireDoubleClick(new DoubleClickEvent((Viewer)this, this.getSelection()));
    }

    protected void fireDoubleClick(final DoubleClickEvent event) {
        Object[] listeners = this.doubleClickListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IDoubleClickListener l = (IDoubleClickListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){
                private static final long serialVersionUID = 7402948979315925968L;

                public void run() {
                    l.doubleClick(event);
                }
            });
            ++i;
        }
    }

    private Object getConnectionAtPosition(int x, int y) {
        Object[] objectArray = this.connections;
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            Object connection = objectArray[n2];
            if (this.isConnectionMarkerAtPosition(connection, x, y)) {
                return connection;
            }
            ++n2;
        }
        return null;
    }

    private boolean isConnectionMarkerAtPosition(Object connection, int x, int y) {
        Rectangle markerBounds = this.getConnectionMarkerBounds(connection);
        return markerBounds != null && markerBounds.contains(x, y);
    }

    private Rectangle getConnectionMarkerBounds(Object connection) {
        IConnectionContentProvider contentProvider = (IConnectionContentProvider)this.getContentProvider();
        Object targetItem = contentProvider.getTargetItem(connection);
        if (targetItem == null) {
            return null;
        }
        if (!this.targetItemResolver.isItemVisible(targetItem, true)) {
            return null;
        }
        int x = this.canvas.getSize().x - 15 - 8;
        int y = this.targetItemResolver.getItemLocation(targetItem, true) - 8;
        return new Rectangle(x, y, 16, 16);
    }

    private void handleCanvasPaint(GC gc) {
        if (this.connections.length > 0) {
            this.paintConnections(gc);
        }
    }

    private void paintConnections(GC gc) {
        this.assertLabelProvider(this.getLabelProvider());
        this.assertSourceItemResolver(this.sourceItemResolver);
        this.assertTargetItemResolver(this.targetItemResolver);
        this.sourceItemResolver.clearCache();
        this.targetItemResolver.clearCache();
        this.paintConnections(gc, this.connections);
    }

    private void paintConnections(GC gc, Object[] connections) {
        Object[] objectArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            Object connection = objectArray[n2];
            this.paintConnection(gc, connection);
            ++n2;
        }
    }

    protected void paintConnection(GC gc, Object connection) {
        IConnectionContentProvider contentProvider = (IConnectionContentProvider)this.getContentProvider();
        Object targetItem = contentProvider.getTargetItem(connection);
        if (!this.targetItemResolver.isItemVisible(targetItem, true)) {
            return;
        }
        int targetHeight = this.targetItemResolver.getItemLocation(targetItem, true);
        if (targetHeight < 0 || targetHeight > this.canvas.getBounds().height) {
            return;
        }
        ArrayList<Integer> sourceHeights = new ArrayList<Integer>();
        Object[] objectArray = contentProvider.getSourceItems(connection);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceItem = objectArray[n2];
            int sourceHeight = this.sourceItemResolver.getItemLocation(sourceItem, true);
            sourceHeights.add(sourceHeight);
            ++n2;
        }
        boolean selected = this.selection.contains(connection);
        Image image = this.getConnectionImage(connection);
        this.paintConnection(gc, sourceHeights, targetHeight, image, selected);
    }

    private Image getConnectionImage(Object connection) {
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        return labelProvider.getImage(connection);
    }

    private void paintConnection(GC gc, Collection<Integer> sourceHeights, int targetHeight, Image markerImage, boolean selected) {
        int markerX = this.canvas.getSize().x - 15;
        int markerY = targetHeight;
        int targetX = this.canvas.getSize().x;
        int targetY = targetHeight;
        gc.setForeground(selected ? this.colorSelected : this.colorDefault);
        gc.setLineWidth(selected ? this.lineWidthSelected : this.lineWidthDefault);
        gc.drawLine(markerX, markerY, targetX, targetY);
        Iterator<Integer> iterator = sourceHeights.iterator();
        while (iterator.hasNext()) {
            int sourceHeight;
            int sourceY = sourceHeight = iterator.next().intValue();
            TwoPointSpline spline = new TwoPointSpline(0, sourceY, markerX, markerY);
            this.splineRenderer.renderSpline(gc, spline);
        }
        if (markerImage != null) {
            int markerImageX = markerX - 8;
            int markerImageY = markerY - 8;
            gc.drawImage(markerImage, 0, 0, markerImage.getBounds().width, markerImage.getBounds().height, markerImageX, markerImageY, 16, 16);
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.selection.toArray());
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.assertSelection(selection);
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        this.selection.clear();
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.selection.add(element);
            ++n2;
        }
        this.refresh();
    }

    private void assertSelection(ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection), (String)INVALID_OR_NULL_SELECTION);
    }

    private void assertContentProvider(IContentProvider provider) {
        Assert.isTrue((boolean)(provider instanceof IConnectionContentProvider), (String)INVALID_OR_MISSING_CONTENT_PROVIDER);
    }

    private void assertLabelProvider(IBaseLabelProvider provider) {
        Assert.isTrue((boolean)(provider instanceof ILabelProvider), (String)INVALID_OR_MISSING_LABEL_PROVIDER);
    }

    private void assertSourceItemResolver(IConnectionItemResolver resolver) {
        Assert.isNotNull((Object)resolver, (String)INVALID_OR_MISSING_SOURCE_ITEM_RESOLVER);
    }

    private void assertTargetItemResolver(IConnectionItemResolver resolver) {
        Assert.isNotNull((Object)resolver, (String)INVALID_OR_MISSING_TARGET_ITEM_RESOLVER);
    }
}

