/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateUtils;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TableColumn;

public class JavascriptServiceTemplateGenerator
extends TemplateGenerator {
    private static final String LOG_TAG = "JAVASCRIPT_SERVICE_GENERATOR";
    private JavascriptServiceTemplateModel model;

    public JavascriptServiceTemplateGenerator(JavascriptServiceTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("projectName", this.model.getProjectName());
        if (this.model.getPackageName() != null) {
            parameters.put("packageName", this.model.getPackageName());
        } else {
            parameters.put("packageName", this.constructPackageName());
        }
        parameters.put("tableName", this.model.getTableName());
        parameters.put("tableType", this.model.getTableType());
        parameters.put("entityName", CommonUtils.toCamelCase((String)this.model.getTableName()));
        parameters.put("tableColumns", this.model.getTableColumns());
        parameters.put("tableColumnsWithoutKeys", this.getTableColumnsWithoutKeys(this.model.getTableColumns()));
        parameters.put("fileName", this.model.getFileName());
        parameters.put("fileNameNoExtension", this.model.getFileNameNoExtension());
        parameters.put("INTEGER", 4);
        parameters.put("BIGINT", -5);
        parameters.put("SMALLINT", 5);
        parameters.put("REAL", 7);
        parameters.put("DOUBLE", 8);
        parameters.put("VARCHAR", 12);
        parameters.put("CHAR", 1);
        parameters.put("DATE", 91);
        parameters.put("TIME", 92);
        parameters.put("TIMESTAMP", 93);
        return parameters;
    }

    public String constructPackageName() {
        StringBuilder result = new StringBuilder();
        Path location = new Path(this.model.getTargetContainer());
        if (location.segmentCount() > 2) {
            int i = 2;
            while (i < location.segmentCount()) {
                result.append(String.valueOf(location.segment(i)) + "/");
                ++i;
            }
            result.delete(result.length() - "/".length(), result.length());
        } else {
            result.append(location.segment(0));
        }
        String constructedPackage = result.toString().replace("/", ".");
        return constructedPackage;
    }

    private TableColumn[] getTableColumnsWithoutKeys(TableColumn[] tableColumns) {
        if (tableColumns == null) {
            return null;
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        TableColumn[] tableColumnArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn2 = tableColumnArray[n2];
            TableColumn tableColumn = tableColumn2;
            if (!tableColumn.isKey()) {
                list.add(tableColumn);
            }
            ++n2;
        }
        return list.toArray(new TableColumn[0]);
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        byte[] result = TemplateUtils.normalizeEscapes((byte[])bytes);
        return result;
    }
}

