/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.job;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.job.CronJob;
import org.eclipse.dirigible.runtime.job.JobParser;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;

public class JobSyncExecutor
extends AbstractScriptExecutor {
    private static final Logger logger = Logger.getLogger(JobSyncExecutor.class);
    private IRepository repository;
    private String[] rootPaths;
    private Gson gson = new Gson();

    public JobSyncExecutor(IRepository repository, String ... rootPaths) {
        logger.debug("entering: constructor()");
        this.repository = repository;
        this.rootPaths = rootPaths;
        if (this.rootPaths == null || this.rootPaths.length == 0) {
            this.rootPaths = new String[2];
        }
        logger.debug("exiting: constructor()");
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        logger.debug("entering: executeServiceModule()");
        logger.debug("module=" + module);
        if (module == null) {
            throw new IOException("Job module cannot be null");
        }
        String result = null;
        String jobDefinition = new String(this.retrieveModule(this.repository, module, "", this.rootPaths).getContent());
        JsonObject jobDefinitionObject = JobParser.parseJob(jobDefinition);
        String jobName = jobDefinitionObject.get("name").getAsString();
        String jobType = jobDefinitionObject.get("type").getAsString();
        String jobModule = jobDefinitionObject.get("module").getAsString();
        Object inputOutput = null;
        result = (inputOutput = this.processJob(request, response, jobModule, executionContext, inputOutput, jobType, jobName)) != null ? inputOutput.toString() : "";
        logger.debug("exiting: executeServiceModule()");
        return result;
    }

    private Object processJob(HttpServletRequest request, HttpServletResponse response, String module, Map<Object, Object> executionContext, Object inputOutput, String jobType, String jobName) throws IOException {
        try {
            inputOutput = CronJob.executeByEngineType(request, response, module, executionContext, jobName, inputOutput, jobType);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        return inputOutput;
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
    }

    protected String getModuleType(String path) {
        return "IntegrationServices";
    }
}

