/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.mobile.wizard;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.Messages;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.ui.common.validation.ValidationStatus;

public class MobileTemplateModel
extends GenerationModel {
    private static final String TARGET_LOCATION_IS_NOT_ALLOWED = Messages.MobileTemplateModel_TARGET_LOCATION_IS_NOT_ALLOWED;

    public IValidationStatus validate() {
        IValidationStatus locationStatus = this.validateLocation();
        if (locationStatus.hasErrors()) {
            return locationStatus;
        }
        IValidationStatus templateStatus = this.validateTemplate();
        if (locationStatus.hasErrors()) {
            return locationStatus;
        }
        return ValidationStatus.getValidationStatus((IValidationStatus)locationStatus, (IValidationStatus)templateStatus);
    }

    public IValidationStatus validateLocation() {
        IValidationStatus status;
        try {
            status = this.validateLocationGeneric();
            if (status.hasErrors()) {
                return status;
            }
            IPath location = new Path(this.getTargetLocation()).append(this.getFileName());
            if (location.toString().indexOf("MobileApplications") == -1) {
                return ValidationStatus.createError((String)TARGET_LOCATION_IS_NOT_ALLOWED);
            }
        }
        catch (Exception exception) {
            return ValidationStatus.createError((String)"");
        }
        return status;
    }
}

