/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.publish;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public abstract class AbstractPublisher
implements IPublisher {
    private static final Logger logger = Logger.getLogger(AbstractPublisher.class);

    protected ICollection getTargetProjectContainer(String registryLocation) throws IOException {
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ICollection publishContainer = repository.getCollection(registryLocation);
        ICollection projectContainer = publishContainer;
        if (projectContainer.exists()) {
            return projectContainer;
        }
        projectContainer.create();
        return projectContainer;
    }

    protected org.eclipse.dirigible.repository.api.IResource getTargetFileLocation(IFile file, String registryLocation) throws IOException {
        ICollection publishContainer;
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ICollection projectContainer = publishContainer = repository.getCollection(registryLocation);
        org.eclipse.dirigible.repository.api.IResource fileResource = projectContainer.getResource(file.getProjectRelativePath().removeFirstSegments(1).toString());
        return fileResource;
    }

    protected IFolder getSourceFolder(IProject project, String sourceFolderName) {
        return project.getFolder(sourceFolderName);
    }

    public void copyAllFromTo(IContainer source, ICollection target) throws CoreException, IOException {
        if (!source.exists()) {
            return;
        }
        String user = this.getUser();
        IResource[] iResourceArray = source.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder) {
                this.copyFolderInto((IFolder)resource, target, user);
            }
            if (resource instanceof IFile) {
                this.copyFileInto((IFile)resource, target, user);
            }
            ++n2;
        }
    }

    public String getUser() {
        String user = CommonParameters.getUserName();
        return user;
    }

    public void copyFolderInto(IFolder folder, ICollection target, String user) throws IOException, CoreException {
        ICollection targetFolder = target.getCollection(folder.getName());
        if (!targetFolder.exists()) {
            targetFolder.create();
        }
        this.copyAllFromTo((IContainer)folder, targetFolder);
    }

    public void copyFileInto(IFile file, ICollection target, String user) throws IOException, CoreException {
        file.getFullPath().toString();
        file.getProject().getFullPath().toString();
        org.eclipse.dirigible.repository.api.IResource targetResource = target.getRepository().getResource(String.valueOf(target.getPath()) + "/" + file.getName());
        org.eclipse.dirigible.repository.api.IResource resource = target.getRepository().getResource(file.getWorkspace().getRoot().getRawLocation() + file.getFullPath().toString());
        if (targetResource.exists()) {
            Date targetResourceLastModifiedAt = targetResource.getInformation().getModifiedAt();
            Date resourceLastModifiedAt = resource.getInformation().getModifiedAt();
            if (resourceLastModifiedAt != null && targetResourceLastModifiedAt != null) {
                if (resourceLastModifiedAt.getTime() >= targetResourceLastModifiedAt.getTime()) {
                    this.setTargetResourceContent(file, targetResource, resource);
                }
            } else {
                this.setTargetResourceContent(file, targetResource, resource);
            }
        } else {
            this.setTargetResourceContent(file, targetResource, resource);
        }
    }

    private void setTargetResourceContent(IFile file, org.eclipse.dirigible.repository.api.IResource targetResource, org.eclipse.dirigible.repository.api.IResource resource) throws IOException, CoreException {
        targetResource.setContent(this.readFile(file), resource.isBinary(), resource.getContentType());
    }

    protected byte[] readFile(IFile file) throws IOException, CoreException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = file.getContents();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }

    protected String generatePublishedPath(IFile file) {
        IPath path = file.getProjectRelativePath();
        if (path != null && path.segmentCount() > 1) {
            path = path.removeFirstSegments(1);
            return String.valueOf('/') + path.toString();
        }
        return null;
    }

    @Override
    public String getPublishedLocation(IFile file) {
        return String.valueOf(CommonParameters.getServicesUrl()) + '/' + "registry" + '/' + this.getFolderType() + this.generatePublishedPath(file);
    }

    @Override
    public String getActivatedLocation(IFile file) {
        return String.valueOf(CommonParameters.getServicesUrl()) + '/' + "sandbox" + '/' + this.getFolderType() + this.generatePublishedPath(file);
    }

    @Override
    public String getPublishedEndpoint(IFile file) {
        if (this.getPublishedContainerMapping(file) == null) {
            return null;
        }
        return String.valueOf(CommonParameters.getServicesUrl()) + this.getPublishedContainerMapping(file) + this.generatePublishedPath(file);
    }

    @Override
    public String getActivatedEndpoint(IFile file) {
        if (this.getActivatedContainerMapping(file) == null) {
            return null;
        }
        return String.valueOf("/".equals(CommonParameters.getServicesUrl()) ? "" : CommonParameters.getServicesUrl()) + this.getActivatedContainerMapping(file) + this.generatePublishedPath(file);
    }

    protected boolean checkFolderType(IFile file) {
        IPath path = file.getProjectRelativePath();
        if (path != null && path.segmentCount() > 0) {
            String folderTypeSegment = path.segment(0);
            if (this.getFolderType().equals(folderTypeSegment)) {
                return true;
            }
        }
        return false;
    }

    protected abstract String getSandboxLocation();

    protected abstract String getRegistryLocation();

    @Override
    public void activateFile(IFile file) throws PublishException {
        if (!this.recognizedFile(file)) {
            return;
        }
        try {
            org.eclipse.dirigible.repository.api.IResource targetFile = this.getTargetFileLocation(file, this.getSandboxLocation());
            if (file.exists()) {
                this.copyFileInto(file, targetFile.getParent(), this.getUser());
            } else if (targetFile.exists()) {
                targetFile.delete();
            }
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getDebugEndpoint(IFile file) {
        return null;
    }

    public String getWorkspaceLocation() {
        return CommonParameters.getWorkspace();
    }

    public ICollection getSourceProjectContainer(IProject project) {
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ICollection workspaceContainer = repository.getCollection(this.getWorkspaceLocation());
        ICollection projectContainer = workspaceContainer.getCollection(project.getName());
        return projectContainer;
    }
}

