/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;

public class AnonymousUserServlet
extends HttpServlet {
    private static final long serialVersionUID = 3669759124907091014L;
    private static final Logger logger = Logger.getLogger(AnonymousUserServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String userName = req.getParameter("user");
        String cookieValue = null;
        if (userName != null && !"".equals(userName.trim())) {
            this.setCookieUser(resp, userName);
            cookieValue = userName;
        } else {
            Cookie[] cookies = req.getCookies();
            String cookieName = "dirigible_anonymous_user";
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookieName.equals(cookie.getName())) {
                    cookieValue = cookie.getValue();
                    break;
                }
                ++i;
            }
            if (cookieValue == null) {
                logger.error("User has not been provider neither as cookie nor as parameter");
                resp.sendError(400, "Use .../anonymous?user=xxx");
                return;
            }
        }
        String redirect = req.getParameter("redirect");
        if (redirect != null && !"".equals(redirect.trim())) {
            resp.sendRedirect("ui/index.html");
        } else {
            resp.getWriter().println(cookieValue);
            resp.getWriter().flush();
            resp.getWriter().close();
        }
    }

    private void setCookieUser(HttpServletResponse resp, String userName) {
        Cookie cookie = new Cookie("dirigible_anonymous_user", userName);
        cookie.setMaxAge(2592000);
        cookie.setPath("/");
        resp.addCookie(cookie);
    }
}

