/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.export;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.db.export.Messages;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableExporter;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.ServiceManager;

public class DataExportServiceHandler
implements ServiceHandler {
    private static final String DSV_EXTENSION = ".dsv";
    private static final String DataExportServiceHandler_ERROR_WHILE_EXPORTING_DSV = Messages.DataExportServiceHandler_ERROR_WHILE_EXPORTING_DSV;
    static final String DataExportServiceHandler_SERVICE_HANDLER_ID = "org.eclipse.dirigible.ide.db.export.DataExportServiceHandler";
    private static final Logger logger = Logger.getLogger(DataExportServiceHandler.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] download;
        String fileName = request.getParameter("filename");
        String tableName = fileName.substring(0, fileName.lastIndexOf(DSV_EXTENSION)).toUpperCase();
        try {
            DBTableExporter dataFinder = new DBTableExporter(DataSourceFacade.getInstance().getDataSource());
            dataFinder.setTableName(tableName);
            download = dataFinder.getTableData().getBytes();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            download = (String.valueOf(DataExportServiceHandler_ERROR_WHILE_EXPORTING_DSV) + tableName).getBytes();
            tableName = "error.txt";
        }
        String contentDisposition = "attachment; filename=\"" + fileName + "\"";
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition", contentDisposition);
        response.getOutputStream().write(download);
    }

    public static String getUrl(String tableName) {
        ServiceManager manager = RWT.getServiceManager();
        String rootURL = manager.getServiceHandlerUrl(DataExportServiceHandler_SERVICE_HANDLER_ID);
        StringBuffer url = new StringBuffer();
        url.append(rootURL);
        url.append("&");
        url.append("filename").append("=").append(tableName.toLowerCase()).append(DSV_EXTENSION);
        int relativeIndex = url.lastIndexOf("/");
        if (relativeIndex > -1) {
            url.delete(0, relativeIndex + 1);
        }
        return RWT.getResponse().encodeURL(url.toString());
    }
}

