/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.preferences;

import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.editors.StringIdentifierEditor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CapraPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String SHOW_TRACE_CREATED_CONFIRMATION_DIALOG = "org.eclipse.capra.preferences.showTraceCreatedConfirmationDialog";
    public static final String SHOW_TRACE_CREATED_CONFIRMATION_DIALOG_LABEL = "Show confirmation after a trace link has been created";
    public static final String SHOW_FULL_TRACE_INFORMATION = "org.eclipse.capra.preferences.showFullTraceInformation";
    public static final String SHOW_FULL_TRACE_INFORMATION_LABEL = "Show the full trace information (including source, targets, and trace type) on the arrows in the PlantUML view";
    private static final String PREFERENCE_PAGE_DESCRIPTION = "Eclipse Capra UI Preferences";
    public static final String CAPRA_PERSISTENCE_PROJECT_NAME_LABEL = "Input new project name for stored traces: ";
    public static final String PROJECT_IDENTIFIER_PATTERN = "^([a-zA-Z_$][a-zA-Z\\d_$]*)$";
    private IPersistenceAdapter persistenceAdapter;
    private EObject traceModel;
    private EObject artifactModel;
    private EObject metadataModel;

    public void init(IWorkbench workbench) {
        this.setDescription(PREFERENCE_PAGE_DESCRIPTION);
        this.setPreferenceStore(CapraPreferences.getPreferences());
        this.persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        this.traceModel = this.persistenceAdapter.getTraceModel(resourceSet);
        this.artifactModel = this.persistenceAdapter.getArtifactWrappers(resourceSet);
        this.metadataModel = this.persistenceAdapter.getMetadataContainer(resourceSet);
    }

    protected void createFieldEditors() {
        BooleanFieldEditor showTraceCreatedDialogEditor = new BooleanFieldEditor(SHOW_TRACE_CREATED_CONFIRMATION_DIALOG, SHOW_TRACE_CREATED_CONFIRMATION_DIALOG_LABEL, this.getFieldEditorParent());
        BooleanFieldEditor showFullTraceInformationEditor = new BooleanFieldEditor(SHOW_FULL_TRACE_INFORMATION, SHOW_FULL_TRACE_INFORMATION_LABEL, this.getFieldEditorParent());
        StringIdentifierEditor stringEditor = new StringIdentifierEditor("org.eclipse.capra.persistence.projectName", CAPRA_PERSISTENCE_PROJECT_NAME_LABEL, 20, this.getFieldEditorParent(), PROJECT_IDENTIFIER_PATTERN, true);
        this.addField((FieldEditor)showTraceCreatedDialogEditor);
        this.addField((FieldEditor)showFullTraceInformationEditor);
        this.addField((FieldEditor)stringEditor);
    }

    public boolean performOk() {
        boolean isOk = super.performOk();
        this.persistenceAdapter.saveModels(this.traceModel, this.artifactModel, this.metadataModel);
        return isOk;
    }

    public static IPreferenceStore getPreferences() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.capra.ui");
    }
}

