/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import java.util.ArrayList;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.capra.ui.notification.DeleteQuickFix;
import org.eclipse.capra.ui.notification.RemoveMarkerQuickFix;
import org.eclipse.capra.ui.notification.RenameOrMoveQuickFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<Object> resolutions = new ArrayList<Object>();
        resolutions.add(new RemoveMarkerQuickFix("Do not update trace links and remove marker."));
        try {
            String issue = (String)marker.getAttribute("issueType");
            if (issue.equals(CapraNotificationHelper.IssueType.RENAMED.getValue()) || issue.equals(CapraNotificationHelper.IssueType.MOVED.getValue())) {
                resolutions.add(new RenameOrMoveQuickFix("Update the trace link to reflect the change."));
            } else if (issue.equals(CapraNotificationHelper.IssueType.DELETED.getValue())) {
                resolutions.add(new DeleteQuickFix("Delete the affected trace link."));
            } else if (issue.equals(CapraNotificationHelper.IssueType.CHANGED.getValue())) {
                resolutions.add(new DeleteQuickFix("Delete the affected trace link."));
            }
            return resolutions.toArray(new IMarkerResolution[0]);
        }
        catch (CoreException coreException) {
            return new IMarkerResolution[0];
        }
    }
}

