/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters090.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.3", "output_model_version=0.9.0", "service.ranking:Integer=90"}, service={IConverter.class})
public class HwConverter
extends AbstractConverter {
    private static final String AM = "am";
    private static final String AMLT_PREFIX = "amlt:/#";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String DEFINITION = "definition";
    private static final String DEFINITIONS = "definitions";
    private static final String STRUCTURES = "structures";
    private static final String STRUCTURE_TYPE = "structureType";
    private static final String AM_MEMORY = "am:Memory";
    private static final String CLASSIFIERS = "classifiers";
    private static final String COMPONENTS = "components";
    private static final String MEMORIES = "memories";
    private static final String MODULES = "modules";
    private static final String NETWORKS = "networks";
    private static final Namespace XSI_NAMESPACE = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
    @Reference
    SessionLogger logger;
    private HWTransformationCache hwTransformationCache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from 0.8.3 to 0.9.0 : Executing HW model converter for model file : {0}", new Object[]{targetFile.getName()});
        this.hwTransformationCache = this.getHWTransformationCache(caches);
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        Element oldHWModelElement = rootElement.getChild("hwModel");
        this.migrateHWModel(rootElement, oldHWModelElement);
    }

    private void migrateHWModel(Element rootElement, Element oldHWModelElement) {
        if (oldHWModelElement == null) {
            return;
        }
        Element newHWModelElement = new Element("hwModel");
        this.migrateAllMemoryTypes(newHWModelElement);
        this.migrateCoreTypes(oldHWModelElement, newHWModelElement);
        this.migrateNetworkTypes(oldHWModelElement, newHWModelElement);
        Element oldHWSystem = oldHWModelElement.getChild("system");
        if (oldHWSystem != null) {
            this.migrateSystem(newHWModelElement, oldHWSystem);
        }
        this.migrateLatencyAccessPath(oldHWModelElement);
        int indexOf = rootElement.indexOf((Content)oldHWModelElement);
        rootElement.removeContent((Content)oldHWModelElement);
        rootElement.addContent(indexOf, (Content)newHWModelElement);
        this.migrateCustomProperties(oldHWModelElement, newHWModelElement);
    }

    private void migrateAllMemoryTypes(Element newHWModelElement) {
        Collection<Element> oldMemoryTypeDefinitions = this.hwTransformationCache.getOldMemoryTypesDefinitionMap().values();
        for (Element oldHWModelElement : oldMemoryTypeDefinitions) {
            this.migrateMemoryTypes(oldHWModelElement, newHWModelElement);
        }
    }

    private void migrateLatencyAccessPath(Element oldHWModelElement) {
        List oldAccessPathList = oldHWModelElement.getChildren("accessPaths");
        for (Element oldAccessPath : oldAccessPathList) {
            String oldAccessPathName = oldAccessPath.getAttributeValue(NAME);
            String oldAccessPathType = oldAccessPath.getAttributeValue(TYPE, XSI_NAMESPACE);
            if (oldAccessPathType == null || !"am:LatencyAccessPath".equals(oldAccessPathType)) continue;
            Map.Entry oldSource = HelperUtil.getSingleElementsNameandTypeFromAttributeOrChildeElement((String)"source", (Element)oldAccessPath);
            Map.Entry oldTarget = HelperUtil.getSingleElementsNameandTypeFromAttributeOrChildeElement((String)"target", (Element)oldAccessPath);
            Element newAccessElement = null;
            if (oldSource != null) {
                String oldSourceName = (String)oldSource.getKey();
                String oldSourceType = (String)oldSource.getValue();
                if ("Core".equals(oldSourceType)) {
                    Element newProcessingUnit = this.hwTransformationCache.getNewCoresMap().get(oldSourceName);
                    if (newProcessingUnit != null) {
                        newAccessElement = new Element("accessElements");
                        newAccessElement.setAttribute(NAME, oldAccessPathName != null ? oldAccessPathName : "");
                        newProcessingUnit.addContent((Content)newAccessElement);
                    }
                } else {
                    this.logger.warn("Unable to migrate LatencyAccessPath from 0.8.3, as the Source type is : {0}. Migration is supported only if source element is of type Core", new Object[]{oldSourceType});
                }
            }
            if (oldTarget != null) {
                Element newDestination = new Element("destination");
                String oldTargetName = (String)oldTarget.getKey();
                String oldTargetType = (String)oldTarget.getValue();
                if ("Memory".equals(oldTargetType)) {
                    newDestination.setAttribute(TYPE, AM_MEMORY, XSI_NAMESPACE);
                    newDestination.setAttribute("href", "amlt://#" + HelperUtil.encodeNameForReference((String)oldTargetName) + "?type=Memory");
                } else if ("Core".equals(oldTargetType)) {
                    newDestination.setAttribute(TYPE, "am:ProcessingUnit", XSI_NAMESPACE);
                    newDestination.setAttribute("href", "amlt://#" + HelperUtil.encodeNameForReference((String)oldTargetName) + "?type=ProcessingUnit");
                } else {
                    this.logger.warn("Unable to migrate LatencyAccessPath destination from 0.8.3 successfully, as the destination type is : {0}. Migration is supported only if target element is of type Memory or Core", new Object[]{oldTargetType});
                }
                if (newAccessElement != null) {
                    newAccessElement.addContent((Content)newDestination);
                }
            }
            if (newAccessElement == null) continue;
            List oldLatencyList = oldAccessPath.getChildren("latencies");
            for (Element oldHW_Latency : oldLatencyList) {
                String oldLatencyAccessType = oldHW_Latency.getAttributeValue("accessType");
                if (oldLatencyAccessType == null) continue;
                ArrayList<Element> newHWLatencies = new ArrayList<Element>();
                if ("R".equals(oldLatencyAccessType)) {
                    newHWLatencies.add(new Element("readLatency"));
                } else {
                    if (!"W".equals(oldLatencyAccessType)) {
                        if (!"RW".equals(oldLatencyAccessType)) continue;
                        newHWLatencies.add(new Element("readLatency"));
                    }
                    newHWLatencies.add(new Element("writeLatency"));
                }
                for (Element newHW_Latency : newHWLatencies) {
                    newAccessElement.addContent((Content)newHW_Latency);
                    String oldLatencyType = oldHW_Latency.getAttributeValue(TYPE, XSI_NAMESPACE);
                    if (oldLatencyType == null) continue;
                    if ("am:LatencyConstant".equals(oldLatencyType)) {
                        newHW_Latency.setAttribute(TYPE, "am:LatencyConstant", XSI_NAMESPACE);
                        String oldLatencyValue = oldHW_Latency.getAttributeValue(VALUE);
                        if (oldLatencyValue == null) continue;
                        newHW_Latency.setAttribute("cycles", oldLatencyValue);
                        continue;
                    }
                    if (!"am:LatencyDeviation".equals(oldLatencyType)) continue;
                    newHW_Latency.setAttribute(TYPE, "am:LatencyDeviation", XSI_NAMESPACE);
                    Element oldLatencyDeviation = oldHW_Latency.getChild("deviation");
                    if (oldLatencyDeviation == null) continue;
                    oldLatencyDeviation = oldLatencyDeviation.clone();
                    oldLatencyDeviation.detach();
                    oldLatencyDeviation.setName("cycles");
                    newHW_Latency.addContent((Content)oldLatencyDeviation);
                }
            }
        }
    }

    private void migrateNetworkTypes(Element oldHWModelElement, Element newHWModelElement) {
        List oldHWNetworkTypes = oldHWModelElement.getChildren("networkTypes");
        for (Element oldHWNetworkType : oldHWNetworkTypes) {
            String oldNetworkTypeSchedPolicy;
            String oldNetworkTypeName = oldHWNetworkType.getAttributeValue(NAME);
            Element newHWNetworkType = new Element(DEFINITIONS);
            newHWModelElement.addContent((Content)newHWNetworkType);
            newHWNetworkType.setAttribute(TYPE, "am:ConnectionHandlerDefinition", XSI_NAMESPACE);
            if (oldNetworkTypeName != null) {
                newHWNetworkType.setAttribute(NAME, oldNetworkTypeName);
            }
            if ((oldNetworkTypeSchedPolicy = oldHWNetworkType.getAttributeValue("schedPolicy")) != null) {
                String policy = "_undefined_";
                if ("RROBIN".equals(oldNetworkTypeSchedPolicy)) {
                    policy = "RoundRobin";
                } else if ("PRIORITY".equals(oldNetworkTypeSchedPolicy)) {
                    policy = "PriorityBased";
                }
                newHWNetworkType.setAttribute("policy", policy);
            }
            this.migrateCustomProperties(oldHWNetworkType, newHWNetworkType);
        }
    }

    private void migrateCoreTypes(Element oldHWModelElement, Element newHWModelElement) {
        List oldCoreTypes = oldHWModelElement.getChildren("coreTypes");
        for (Element oldCoreType : oldCoreTypes) {
            String oldCoreTypeName = oldCoreType.getAttributeValue(NAME);
            Element newHWCoreType = new Element(DEFINITIONS);
            newHWModelElement.addContent((Content)newHWCoreType);
            newHWCoreType.setAttribute(TYPE, "am:ProcessingUnitDefinition", XSI_NAMESPACE);
            if (oldCoreTypeName != null) {
                newHWCoreType.setAttribute(NAME, oldCoreTypeName);
            }
            newHWCoreType.setAttribute("puType", "CPU");
            Attribute oldCoreTypeClassifiers = oldCoreType.getAttribute(CLASSIFIERS);
            if (oldCoreTypeClassifiers != null) {
                newHWCoreType.setAttribute(oldCoreTypeClassifiers.clone());
            } else {
                List oldCoreTypeClassifiersList = oldCoreType.getChildren(CLASSIFIERS);
                for (Element oldCoreType_Classifier : oldCoreTypeClassifiersList) {
                    newHWCoreType.addContent((Content)oldCoreType_Classifier.clone());
                }
            }
            String oldCoreTypeICP = oldCoreType.getAttributeValue("instructionsPerCycle");
            if (oldCoreTypeICP != null) {
                String ipcValue = oldCoreTypeICP;
                oldCoreTypeICP = "IPC_" + ipcValue;
                String newHWFeatureCategoryName = "Instructions";
                Element newHWFeatureCategories = new Element("featureCategories");
                newHWFeatureCategories.setAttribute(NAME, newHWFeatureCategoryName);
                if (this.hwTransformationCache.getNewFeatureCategoriesMap().containsKey(newHWFeatureCategoryName)) {
                    newHWFeatureCategories = this.hwTransformationCache.getNewFeatureCategoriesMap().get(newHWFeatureCategoryName);
                } else {
                    newHWModelElement.addContent((Content)newHWFeatureCategories);
                }
                newHWFeatureCategories.setAttribute("featureType", "performance");
                if (!this.hwTransformationCache.getNewFeaturesMap().containsKey(String.valueOf(newHWFeatureCategoryName) + "/" + oldCoreTypeICP)) {
                    Element newHWFeatureElement = new Element("features");
                    newHWFeatureElement.setAttribute(NAME, oldCoreTypeICP);
                    newHWFeatureElement.setAttribute(VALUE, ipcValue);
                    newHWFeatureCategories.addContent((Content)newHWFeatureElement);
                    this.hwTransformationCache.getNewFeaturesMap().put(String.valueOf(newHWFeatureCategoryName) + "/" + oldCoreTypeICP, newHWFeatureElement);
                }
                this.hwTransformationCache.getNewFeatureCategoriesMap().put(newHWFeatureCategoryName, newHWFeatureCategories);
                Element newHwFeaturesElement = new Element("features");
                newHwFeaturesElement.setAttribute("href", AMLT_PREFIX + newHWFeatureCategoryName + "/" + oldCoreTypeICP + "?type=HwFeature");
                newHWCoreType.addContent((Content)newHwFeaturesElement);
            }
            this.migrateCustomProperties(oldCoreType, newHWCoreType);
        }
    }

    private void migrateMemoryTypes(Element oldMemoryTypeElement, Element newHWModelElement) {
        Element oldMemoryTypeSize;
        String oldMemoryTypeName = oldMemoryTypeElement.getAttributeValue(NAME);
        String oldMemoryTypeType = oldMemoryTypeElement.getAttributeValue(TYPE);
        Element newHWMemoryType = new Element(DEFINITIONS);
        newHWModelElement.addContent((Content)newHWMemoryType);
        if ("CACHE".equals(oldMemoryTypeType)) {
            newHWMemoryType.setAttribute(TYPE, "am:CacheDefinition", XSI_NAMESPACE);
            this.hwTransformationCache.getNewCacheTypesDefinitionMap().put(HelperUtil.encodeName((String)oldMemoryTypeName), newHWMemoryType);
        } else {
            newHWMemoryType.setAttribute(TYPE, "am:MemoryDefinition", XSI_NAMESPACE);
            this.hwTransformationCache.getNewMemoryTypesDefinitionMap().put(HelperUtil.encodeName((String)oldMemoryTypeName), newHWMemoryType);
            Attribute oldMemoryTypeClassifiersAttribute = oldMemoryTypeElement.getAttribute(CLASSIFIERS);
            if (oldMemoryTypeClassifiersAttribute != null) {
                newHWMemoryType.setAttribute(oldMemoryTypeClassifiersAttribute.clone());
            } else {
                List oldMemoryTypeClassifiersList = oldMemoryTypeElement.getChildren(CLASSIFIERS);
                for (Element oldMemoryTypeClassifier : oldMemoryTypeClassifiersList) {
                    newHWMemoryType.addContent((Content)oldMemoryTypeClassifier.clone());
                }
            }
        }
        if (oldMemoryTypeName != null) {
            newHWMemoryType.setAttribute(NAME, oldMemoryTypeName);
        }
        if ((oldMemoryTypeSize = oldMemoryTypeElement.getChild("size")) != null) {
            newHWMemoryType.addContent((Content)oldMemoryTypeSize.clone());
        }
        this.migrateCustomProperties(oldMemoryTypeElement, newHWMemoryType);
    }

    private void migrateSystem(Element newHWModelElement, Element oldHWSystem) {
        String oldHWSystemName = oldHWSystem.getAttributeValue(NAME);
        Element newHWSystem = new Element(STRUCTURES);
        if (oldHWSystemName != null) {
            newHWSystem.setAttribute(NAME, oldHWSystemName);
        }
        newHWSystem.setAttribute(STRUCTURE_TYPE, "System");
        newHWModelElement.addContent((Content)newHWSystem);
        this.hwTransformationCache.getNewSystemsMap().put(HelperUtil.encodeName((String)oldHWSystemName), newHWSystem);
        this.migrateAllQuartzes(newHWModelElement);
        List oldHWecus = oldHWSystem.getChildren("ecus");
        for (Element oldHWEcu : oldHWecus) {
            this.migrateECU(newHWSystem, oldHWEcu);
        }
        this.migrateMemoriesAndCaches(oldHWSystem, newHWSystem, true, true);
        this.migrateNetworks(oldHWSystem, newHWSystem);
        this.migratePorts(oldHWSystem, newHWSystem);
        this.migrateCustomProperties(oldHWSystem, newHWSystem);
    }

    private void migratePorts(Element oldHWElement, Element newHWElement) {
        List oldHWPortElementList = oldHWElement.getChildren("ports");
        for (Element oldHWPort : oldHWPortElementList) {
            Element newHWPort = new Element("ports");
            String oldHWPortName = oldHWPort.getAttributeValue(NAME);
            String oldHWPortBitWidth = oldHWPort.getAttributeValue("bitWidth");
            String oldHWPortMaster = oldHWPort.getAttributeValue("master");
            if (oldHWPortName != null) {
                newHWPort.setAttribute(NAME, oldHWPortName);
            }
            if (oldHWPortBitWidth != null) {
                newHWPort.setAttribute("bitWidth", oldHWPortBitWidth);
            }
            if (oldHWPortMaster != null) {
                if (Boolean.parseBoolean(oldHWPortMaster.trim())) {
                    newHWPort.setAttribute("portType", "initiator");
                } else {
                    newHWPort.setAttribute("portType", "responder");
                }
            }
            newHWElement.addContent((Content)newHWPort);
            this.migrateCustomProperties(oldHWPort, newHWPort);
        }
    }

    private void migrateMemoriesAndCaches(Element oldElement, Element newElement, boolean migrateCache, boolean migrateMemory) {
        List<Element> oldMemoryElementList = this.getAllMemories(oldElement);
        for (Element oldMemoryElement : oldMemoryElementList) {
            Element newMemoryElement = new Element(MODULES);
            String oldMemoryName = oldMemoryElement.getAttributeValue(NAME);
            if (oldMemoryName != null) {
                newMemoryElement.setAttribute(NAME, oldMemoryName);
            }
            String oldTypeDefinitionName = HelperUtil.getSingleElementNameFromAttributeOrChildeElement((String)TYPE, (Element)oldMemoryElement);
            String newDefinitionType = "MemoryDefinition";
            boolean isElementAddedToTheParent = false;
            if (oldTypeDefinitionName != null) {
                if (migrateCache && this.hwTransformationCache.getNewCacheTypesDefinitionMap().containsKey(oldTypeDefinitionName)) {
                    newDefinitionType = "CacheDefinition";
                    if (migrateCache && !migrateMemory) {
                        newMemoryElement.setName("caches");
                    }
                    newMemoryElement.setAttribute(TYPE, "am:Cache", XSI_NAMESPACE);
                    this.hwTransformationCache.getNewCachesMap().put(HelperUtil.encodeName((String)oldMemoryName), newMemoryElement);
                    newElement.addContent((Content)newMemoryElement);
                    isElementAddedToTheParent = true;
                }
                if (migrateMemory && this.hwTransformationCache.getNewMemoryTypesDefinitionMap().containsKey(oldTypeDefinitionName)) {
                    newMemoryElement.setAttribute(TYPE, AM_MEMORY, XSI_NAMESPACE);
                    this.hwTransformationCache.getNewMemoriesMap().put(HelperUtil.encodeName((String)oldMemoryName), newMemoryElement);
                    newElement.addContent((Content)newMemoryElement);
                    isElementAddedToTheParent = true;
                }
            } else if (migrateMemory) {
                newMemoryElement.setAttribute(TYPE, AM_MEMORY, XSI_NAMESPACE);
                this.hwTransformationCache.getNewMemoriesMap().put(HelperUtil.encodeName((String)oldMemoryName), newMemoryElement);
                newElement.addContent((Content)newMemoryElement);
                isElementAddedToTheParent = true;
            }
            if (!isElementAddedToTheParent) continue;
            List<Element> newHWMemoryDefinitions = this.migrateAttributeorElementData(oldMemoryElement, TYPE, DEFINITION, newDefinitionType);
            for (Element newHWMemoryDefinition : newHWMemoryDefinitions) {
                newMemoryElement.addContent((Content)newHWMemoryDefinition);
            }
            this.migratePrescaler(oldMemoryElement, newMemoryElement);
            this.migratePorts(oldMemoryElement, newMemoryElement);
            this.migrateCustomProperties(oldMemoryElement, newMemoryElement);
        }
    }

    private void migrateNetworks(Element oldElement, Element newElement) {
        List<Element> oldNetworkList = this.getAllNetworks(oldElement);
        for (Element oldNetwork : oldNetworkList) {
            Element newNetwork = new Element(MODULES);
            String oldNetworkName = oldNetwork.getAttributeValue(NAME);
            if (oldNetworkName != null) {
                newNetwork.setAttribute(NAME, oldNetworkName);
            }
            newNetwork.setAttribute(TYPE, "am:ConnectionHandler", XSI_NAMESPACE);
            List<Element> newHWNetworkTypeDefinitions = this.migrateAttributeorElementData(oldNetwork, TYPE, DEFINITION, "ConnectionHandlerDefinition");
            for (Element newHWNetworkTypeDefinition : newHWNetworkTypeDefinitions) {
                newNetwork.addContent((Content)newHWNetworkTypeDefinition);
            }
            this.migratePrescaler(oldNetwork, newNetwork);
            this.migratePorts(oldNetwork, newNetwork);
            newElement.addContent((Content)newNetwork);
            this.migrateCustomProperties(oldNetwork, newNetwork);
        }
    }

    private List<Element> getAllNetworks(Element oldComplexNode) {
        ArrayList<Element> oldNetworkList = new ArrayList<Element>();
        List oldComplexNodeList = oldComplexNode.getChildren(NETWORKS);
        oldNetworkList.addAll(oldComplexNodeList);
        this.populateAllSubNetworks(oldNetworkList, oldComplexNode.getChildren(NETWORKS));
        this.populateAllSubNetworks(oldNetworkList, oldComplexNode.getChildren(MEMORIES));
        this.populateAllSubNetworks(oldNetworkList, oldComplexNode.getChildren(COMPONENTS));
        return oldNetworkList;
    }

    private List<Element> getAllMemories(Element oldComplexNode) {
        ArrayList<Element> oldMemoryList = new ArrayList<Element>();
        List oldComplexNodeList = oldComplexNode.getChildren(MEMORIES);
        oldMemoryList.addAll(oldComplexNodeList);
        this.populateAllSubMemories(oldMemoryList, oldComplexNode.getChildren(MEMORIES));
        this.populateAllSubMemories(oldMemoryList, oldComplexNode.getChildren(NETWORKS));
        this.populateAllSubMemories(oldMemoryList, oldComplexNode.getChildren(COMPONENTS));
        return oldMemoryList;
    }

    private void populateAllSubMemories(List<Element> oldMemoryElements, List<Element> oldComplexNodeElements) {
        for (Element oldHWMemory : oldComplexNodeElements) {
            StringBuilder xpathBufferForMemoryDefinitions = new StringBuilder();
            xpathBufferForMemoryDefinitions.append("./memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//components/memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//nestedComponents/memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//memories/memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//networks/memories");
            List memoryElements = HelperUtil.getXpathResult((Element)oldHWMemory, (String)xpathBufferForMemoryDefinitions.toString(), Element.class, (Namespace[])new Namespace[]{XSI_NAMESPACE, AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_090, (String)AM)});
            oldMemoryElements.addAll(memoryElements);
        }
    }

    private void populateAllSubNetworks(List<Element> oldNetworkElements, List<Element> oldComplexNodeElements) {
        for (Element oldHWNetwork : oldComplexNodeElements) {
            StringBuilder xpathBufferForMemoryDefinitions = new StringBuilder();
            xpathBufferForMemoryDefinitions.append("./networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//components/networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//nestedComponents/networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//memories/networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//networks/networks");
            List networkElements = HelperUtil.getXpathResult((Element)oldHWNetwork, (String)xpathBufferForMemoryDefinitions.toString(), Element.class, (Namespace[])new Namespace[]{XSI_NAMESPACE, AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_090, (String)AM)});
            oldNetworkElements.addAll(networkElements);
        }
    }

    private void migrateAllQuartzes(Element newHWModel) {
        Collection<Element> oldQuartzElementColl = this.hwTransformationCache.getOldHwQuartzsMap().values();
        for (Element oldQuartzElement : oldQuartzElementColl) {
            Element oldFrequencyElement;
            Element newHWFrequencyDomain = new Element("domains");
            newHWFrequencyDomain.setAttribute(TYPE, "am:FrequencyDomain", XSI_NAMESPACE);
            String oldHWQuartzName = oldQuartzElement.getAttributeValue(NAME);
            if (oldHWQuartzName != null) {
                newHWFrequencyDomain.setAttribute(NAME, oldHWQuartzName);
            }
            if ((oldFrequencyElement = oldQuartzElement.getChild("frequency")) != null) {
                Element newFrequencyDefaultValueElement = oldFrequencyElement.clone();
                newFrequencyDefaultValueElement.detach();
                newFrequencyDefaultValueElement.setName("defaultValue");
                newHWFrequencyDomain.addContent((Content)newFrequencyDefaultValueElement);
            }
            newHWModel.addContent((Content)newHWFrequencyDomain);
            this.migrateCustomProperties(oldQuartzElement, newHWFrequencyDomain);
            this.hwTransformationCache.getNewHwQuartzsFrequencyDomainMap().put(HelperUtil.encodeName((String)oldHWQuartzName), newHWFrequencyDomain);
        }
    }

    private void migrateECU(Element newHWSystem, Element oldEcu) {
        String oldEcuName = oldEcu.getAttributeValue(NAME);
        this.hwTransformationCache.getOldEcusMap().put(HelperUtil.encodeName((String)oldEcuName), oldEcu);
        Element newEcu = new Element(STRUCTURES);
        if (oldEcuName != null) {
            newEcu.setAttribute(NAME, oldEcuName);
        }
        newEcu.setAttribute(STRUCTURE_TYPE, "ECU");
        newHWSystem.addContent((Content)newEcu);
        this.hwTransformationCache.getNewEcusMap().put(HelperUtil.encodeName((String)oldEcuName), newEcu);
        this.migrateMemoriesAndCaches(oldEcu, newEcu, true, true);
        this.migrateNetworks(oldEcu, newEcu);
        this.migratePorts(oldEcu, newEcu);
        List oldHWMicroControllers = oldEcu.getChildren("microcontrollers");
        for (Element oldHWMicroController : oldHWMicroControllers) {
            this.migrateMicroController(newEcu, oldHWMicroController);
        }
        this.migrateCustomProperties(oldEcu, newEcu);
    }

    private void migrateMicroController(Element newEcu, Element oldMicroController) {
        String oldMicroControllerName = oldMicroController.getAttributeValue(NAME);
        this.hwTransformationCache.getOldMicroControllersMap().put(HelperUtil.encodeName((String)oldMicroControllerName), oldMicroController);
        Element newMicroController = new Element(STRUCTURES);
        if (oldMicroControllerName != null) {
            newMicroController.setAttribute(NAME, oldMicroControllerName);
        }
        newMicroController.setAttribute(STRUCTURE_TYPE, "Microcontroller");
        newEcu.addContent((Content)newMicroController);
        this.hwTransformationCache.getNewMicroControllersMap().put(HelperUtil.encodeName((String)oldMicroControllerName), newMicroController);
        this.migrateMemoriesAndCaches(oldMicroController, newMicroController, true, true);
        this.migrateNetworks(oldMicroController, newMicroController);
        this.migratePorts(oldMicroController, newMicroController);
        List oldHWCores = oldMicroController.getChildren("cores");
        for (Element oldHWCore : oldHWCores) {
            this.migrateCore(newMicroController, oldHWCore);
            this.migrateMemoriesAndCaches(oldHWCore, newMicroController, false, true);
            this.migrateNetworks(oldHWCore, newMicroController);
        }
        this.migrateCustomProperties(oldMicroController, newMicroController);
    }

    private void migrateCore(Element newMicroController, Element oldCore) {
        Element newCore = new Element(MODULES);
        newMicroController.addContent((Content)newCore);
        newCore.setAttribute(TYPE, "am:ProcessingUnit", XSI_NAMESPACE);
        String oldCoreName = oldCore.getAttributeValue(NAME);
        if (oldCoreName != null) {
            newCore.setAttribute(NAME, oldCoreName);
        }
        List<Element> newProcessingUnitList = this.migrateAttributeorElementData(oldCore, "coreType", DEFINITION, "ProcessingUnitDefinition");
        for (Element newProcessingUnit : newProcessingUnitList) {
            newCore.addContent((Content)newProcessingUnit);
        }
        this.migratePrescaler(oldCore, newCore);
        this.migratePorts(oldCore, newCore);
        this.migrateMemoriesAndCaches(oldCore, newCore, true, false);
        this.hwTransformationCache.getNewCoresMap().put(HelperUtil.encodeName((String)oldCoreName), newCore);
        this.migrateCustomProperties(oldCore, newCore);
    }

    private void migratePrescaler(Element oldHWElement, Element newHWElement) {
        String oldQuartzName;
        Element oldPrescaler = oldHWElement.getChild("prescaler");
        if (oldPrescaler != null && (oldQuartzName = HelperUtil.getSingleElementNameFromAttributeOrChildeElement((String)"quartz", (Element)oldPrescaler)) != null) {
            Element newFrequencyDomainBaseFrequency;
            String clockRatio = oldPrescaler.getAttributeValue("clockRatio");
            if (clockRatio == null) {
                clockRatio = "0.0";
            }
            String newFrequencyDomainName = "";
            newFrequencyDomainName = "1.0".equals(clockRatio.trim()) ? oldQuartzName : String.valueOf(oldQuartzName) + "__" + clockRatio;
            Element newFrequencyDomain = this.hwTransformationCache.getNewHwQuartzsFrequencyDomainMap().get(newFrequencyDomainName);
            if (newFrequencyDomain == null && (newFrequencyDomainBaseFrequency = this.hwTransformationCache.getNewHwQuartzsFrequencyDomainMap().get(oldQuartzName)) != null) {
                Attribute newFrequencyValueAttribute;
                Element parentElement = newFrequencyDomainBaseFrequency.getParentElement();
                newFrequencyDomain = newFrequencyDomainBaseFrequency.clone();
                newFrequencyDomain.detach();
                newFrequencyDomainName = String.valueOf(oldQuartzName) + "__" + clockRatio;
                newFrequencyDomain.setAttribute(NAME, newFrequencyDomainName);
                parentElement.addContent((Content)newFrequencyDomain);
                this.hwTransformationCache.getNewHwQuartzsFrequencyDomainMap().put(newFrequencyDomainName, newFrequencyDomain);
                Element newFrequency = newFrequencyDomain.getChild("defaultValue");
                if (newFrequency != null && (newFrequencyValueAttribute = newFrequency.getAttribute(VALUE)) != null) {
                    try {
                        String value = newFrequencyValueAttribute.getValue();
                        String newFrequencyValue = String.valueOf(Double.parseDouble(value) * Double.parseDouble(clockRatio));
                        newFrequencyValueAttribute.setValue(newFrequencyValue);
                    }
                    catch (Exception e) {
                        this.logger.error("Exception occured during creation of new FrequencyDomain : {0}", new Object[]{newFrequencyDomain.getAttributeValue(NAME)});
                    }
                }
            }
            if (newFrequencyDomain != null) {
                Element newFrequencyDoaminReference = new Element("frequencyDomain");
                newFrequencyDoaminReference.setAttribute("href", AMLT_PREFIX + HelperUtil.encodeNameForReference((String)newFrequencyDomain.getAttributeValue(NAME)) + "?type=FrequencyDomain");
                newHWElement.addContent((Content)newFrequencyDoaminReference);
            }
        }
    }

    private List<Element> migrateAttributeorElementData(Element oldHWElement, String attributeOrChildElementName, String newChildElementName, String newChildElementType) {
        ArrayList<Element> newHWElements = new ArrayList<Element>();
        Attribute oldHWAttribute = oldHWElement.getAttribute(attributeOrChildElementName);
        if (oldHWAttribute != null) {
            String oldHWRefElementsValue = oldHWAttribute.getValue();
            StringTokenizer stk = new StringTokenizer(oldHWRefElementsValue);
            while (stk.hasMoreTokens()) {
                String nextToken = stk.nextToken();
                String newHWRefElementName = this.updateReferenceStringWithNewType(nextToken, newChildElementType);
                Element newHWRefElement = new Element(newChildElementName);
                newHWRefElement.setAttribute("href", AMLT_PREFIX + newHWRefElementName);
                newHWElements.add(newHWRefElement);
            }
        } else {
            List oldHWChildElements = oldHWElement.getChildren(attributeOrChildElementName);
            for (Element oldHWChildElement : oldHWChildElements) {
                String oldHWhrefValue = oldHWChildElement.getAttributeValue("href");
                if (oldHWhrefValue == null) continue;
                String newHWRefElementName = this.updateReferenceStringWithNewType(oldHWhrefValue, newChildElementType);
                Element newHWRefElement = new Element(newChildElementName);
                newHWRefElement.setAttribute("href", newHWRefElementName);
                newHWElements.add(newHWRefElement);
            }
        }
        oldHWElement.removeAttribute(attributeOrChildElementName);
        oldHWElement.removeChildren(attributeOrChildElementName);
        return newHWElements;
    }

    private String updateReferenceStringWithNewType(String inputString, String newType) {
        if (inputString != null) {
            int startIndex = inputString.indexOf("?type=");
            if (startIndex != -1) {
                String oldHWRefElementName = inputString.substring(0, startIndex);
                return String.valueOf(oldHWRefElementName) + "?type=" + newType;
            }
            return inputString;
        }
        return inputString;
    }

    private void migrateCustomProperties(Element oldHwElement, Element newHwElement) {
        List customProperties = oldHwElement.getChildren("customProperties");
        for (Element customProperty : customProperties) {
            Element newHwCustomProperty = customProperty.clone();
            newHwCustomProperty.detach();
            newHwElement.addContent((Content)newHwCustomProperty);
        }
    }

    private HWTransformationCache getHWTransformationCache(List<ICache> caches) {
        if (caches == null) {
            return null;
        }
        for (ICache cache : caches) {
            Map map;
            Map cacheMap;
            if (!(cache instanceof HWCacheBuilder) || (cacheMap = cache.getCacheMap()) == null || cacheMap.isEmpty() || (map = (Map)cacheMap.values().iterator().next()) == null) continue;
            Object object = map.get("globalCache");
            return (HWTransformationCache)object;
        }
        return new HWTransformationCache();
    }
}

