/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.util.CancelIndicator;

public class LibraryElementXtextResource
extends LazyLinkingResource {
    private LibraryElement libraryElement;
    private final List<EObject> additionalContent = new ArrayList<EObject>();
    private boolean includeInternalLibraryElement = true;

    public void updateInternalLibraryElement() {
        this.clearInternalLibraryElement();
        if (this.contents != null && !this.contents.isEmpty()) {
            if (this.libraryElement != null) {
                this.contents.add((Object)LibraryElementXtextResource.copyLibraryElement(this.libraryElement, !this.includeInternalLibraryElement));
            }
            this.contents.addAll(EcoreUtil.copyAll(this.additionalContent));
            this.relink();
        }
    }

    protected void clearInternalLibraryElement() {
        if (this.contents != null) {
            this.contents.removeIf(LibraryElement.class::isInstance);
            this.contents.removeAll(this.additionalContent);
        }
    }

    public void setLibraryElement(LibraryElement libraryElement) {
        this.libraryElement = libraryElement;
        this.updateInternalLibraryElement();
    }

    public LibraryElement getLibraryElement() {
        return this.libraryElement;
    }

    public LibraryElement getInternalLibraryElement() {
        return LibraryElementXtextResource.findInternalLibraryElement((Resource)this);
    }

    protected static LibraryElement findInternalLibraryElement(Resource resource) {
        return resource.getContents().stream().filter(LibraryElement.class::isInstance).map(LibraryElement.class::cast).findFirst().orElse(null);
    }

    public List<EObject> getAdditionalContent() {
        return this.additionalContent;
    }

    public boolean isIncludeInternalLibraryElement() {
        return this.includeInternalLibraryElement;
    }

    public void setIncludeInternalLibraryElement(boolean includeInternalLibraryElement) {
        this.includeInternalLibraryElement = includeInternalLibraryElement;
        this.updateInternalLibraryElement();
    }

    public synchronized EObject getEObject(String uriFragment) {
        try {
            return super.getEObject(uriFragment);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        this.clearCache();
        super.resolveLazyCrossReferences(mon);
    }

    public static URI getExternalURI(EObject object) {
        return LibraryElementXtextResource.toExternalURI(EcoreUtil.getURI((EObject)object));
    }

    public static URI getInternalURI(EObject object) {
        return LibraryElementXtextResource.toInternalURI(EcoreUtil.getURI((EObject)object));
    }

    public static URI toExternalURI(URI uri) {
        if (uri != null && uri.hasFragment() && uri.fragment().startsWith("/1")) {
            return uri.trimQuery().trimFragment().appendFragment("/" + uri.fragment().substring(2));
        }
        return uri;
    }

    public static URI toInternalURI(URI uri) {
        if (uri != null && uri.hasFragment() && !uri.fragment().startsWith("/1")) {
            return uri.trimFragment().appendFragment("/1" + uri.fragment().substring(1));
        }
        return uri;
    }

    public static String toExternalFragment(String fragment) {
        if (fragment != null && fragment.startsWith("/1")) {
            return "/" + fragment.substring(2);
        }
        return fragment;
    }

    public static String toInternalFragment(String fragment) {
        if (fragment != null && !fragment.startsWith("/1")) {
            return "/1" + fragment.substring(1);
        }
        return fragment;
    }

    protected static LibraryElement copyLibraryElement(LibraryElement libraryElement, boolean shallow) {
        ShallowCopier copier = shallow ? new ShallowCopier() : new EcoreUtil.Copier();
        LibraryElement result = (LibraryElement)copier.copy((EObject)libraryElement);
        copier.copyReferences();
        return result;
    }

    protected static class ShallowCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;

        protected ShallowCopier() {
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (!LibraryElementPackage.Literals.LIBRARY_ELEMENT.isSuperTypeOf(eObject.eClass()) || LibraryElementPackage.Literals.LIBRARY_ELEMENT__COMPILER_INFO == eReference) {
                super.copyContainment(eReference, eObject, copyEObject);
            }
        }
    }
}

