/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;

public final class CallableAnnotations {
    private CallableAnnotations() {
        throw new UnsupportedOperationException("Helper class must not be instantiated");
    }

    static EList<ITypedElement> getInputParameters(Algorithm algorithm) {
        return ECollections.emptyEList();
    }

    static EList<ITypedElement> getOutputParameters(Algorithm algorithm) {
        return ECollections.emptyEList();
    }

    static EList<ITypedElement> getInOutParameters(Algorithm algorithm) {
        return ECollections.emptyEList();
    }

    static DataType getReturnType(Algorithm algorithm) {
        return null;
    }

    static EList<ITypedElement> getInputParameters(FBType type) {
        return ECollections.unmodifiableEList(type.getInterfaceList().getInputVars());
    }

    static EList<ITypedElement> getOutputParameters(FBType type) {
        return ECollections.unmodifiableEList(type.getInterfaceList().getOutputVars().stream().filter(v -> !v.getName().isEmpty()).toList());
    }

    static EList<ITypedElement> getInOutParameters(FBType type) {
        return ECollections.unmodifiableEList(type.getInterfaceList().getInOutVars());
    }

    static DataType getReturnType(FBType type) {
        return type.getInterfaceList().getOutputVars().stream().filter(v -> v.getName().isEmpty()).findAny().map(IInterfaceElement::getType).orElse(null);
    }

    static EList<ITypedElement> getInputParameters(Event event) {
        EObject eObject = event.eContainer();
        if (eObject instanceof InterfaceList) {
            InterfaceList interfaceList = (InterfaceList)eObject;
            return ECollections.unmodifiableEList(interfaceList.getInputVars());
        }
        return ECollections.emptyEList();
    }

    static EList<ITypedElement> getOutputParameters(Event event) {
        EObject eObject = event.eContainer();
        if (eObject instanceof InterfaceList) {
            InterfaceList interfaceList = (InterfaceList)eObject;
            return ECollections.unmodifiableEList(interfaceList.getOutputVars().stream().filter(v -> !v.getName().isEmpty()).toList());
        }
        return ECollections.emptyEList();
    }

    static EList<ITypedElement> getInOutParameters(Event event) {
        EObject eObject = event.eContainer();
        if (eObject instanceof InterfaceList) {
            InterfaceList interfaceList = (InterfaceList)eObject;
            return ECollections.unmodifiableEList(interfaceList.getInOutVars());
        }
        return ECollections.emptyEList();
    }

    static DataType getReturnType(Event event) {
        EObject eObject = event.eContainer();
        if (eObject instanceof InterfaceList) {
            InterfaceList interfaceList = (InterfaceList)eObject;
            return interfaceList.getOutputVars().stream().filter(v -> v.getName().isEmpty()).findAny().map(IInterfaceElement::getType).orElse(null);
        }
        return null;
    }

    static EList<ITypedElement> getInputParameters(FB fb) {
        return ECollections.unmodifiableEList(fb.getInterface().getInputVars());
    }

    static EList<ITypedElement> getOutputParameters(FB fb) {
        return ECollections.unmodifiableEList(fb.getInterface().getOutputVars().stream().filter(v -> !v.getName().isEmpty()).toList());
    }

    static EList<ITypedElement> getInOutParameters(FB fb) {
        return ECollections.unmodifiableEList(fb.getInterface().getInOutVars());
    }

    static DataType getReturnType(FB fb) {
        return fb.getInterface().getOutputVars().stream().filter(v -> v.getName().isEmpty()).findAny().map(IInterfaceElement::getType).orElse(null);
    }

    public static String getSignature(ICallable callable) {
        return callable.getName() + Stream.of(callable.getInputParameters().stream().map(CallableAnnotations::getInputParameterSignature), callable.getInOutParameters().stream().map(CallableAnnotations::getInOutParameterSignature), callable.getOutputParameters().stream().map(CallableAnnotations::getOutputParameterSignature)).flatMap(Function.identity()).collect(Collectors.joining(", ", "(", callable.isVarargs() ? " ...)" : ")")) + (String)(callable.getReturnType() != null ? " : " + callable.getReturnType().getName() : "");
    }

    static String getInputParameterSignature(ITypedElement parameter) {
        return CallableAnnotations.getParameterSignature(parameter, "");
    }

    static String getInOutParameterSignature(ITypedElement parameter) {
        return CallableAnnotations.getParameterSignature(parameter, "&&");
    }

    static String getOutputParameterSignature(ITypedElement parameter) {
        return CallableAnnotations.getParameterSignature(parameter, "&");
    }

    static String getParameterSignature(ITypedElement parameter, String typePrefix) {
        return parameter.getName() + " : " + typePrefix + parameter.getFullTypeName();
    }

    public static boolean isVarargs(ICallable callable) {
        return false;
    }
}

