/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.helpers.ModelHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.search.Match;
import org.eclipse.fordiac.ide.model.search.Messages;
import org.eclipse.fordiac.ide.model.search.ModelSearchResult;
import org.eclipse.fordiac.ide.model.search.ModelSearchTableContentProvider;
import org.eclipse.fordiac.ide.model.search.SearchResultTextMatch;
import org.eclipse.fordiac.ide.model.search.TextMatch;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;

public class ModelSearchResultPage
extends AbstractTextSearchViewPage {
    private static final String ID = "org.eclipse.fordiac.ide.model.search.ModelSearchResultPage";
    private ModelSearchTableContentProvider contentProvider;
    private String searchDescription;
    private static final int ELEMENT_KIND_COLUMN_WIDTH = 10;
    private static final int NAME_COLUMN_WIDTH = 10;
    private static final int COMMENT_COLUMN_WIDTH = 10;
    private static final int TYPE_COLUMN_WIDTH = 20;
    private static final int PATH_COLUMN_WIDTH = 20;
    private static final int LOCATION_COLUMN_WIDTH = 20;
    private static final String PATH_COLUMN = "Path";
    private static final String ELEMENT_KIND_COLUMN = "Element Kind";
    private static final String LOCATION_COLUMN = "Location";

    public ModelSearchResultPage() {
        super(1);
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public String getID() {
        return ID;
    }

    public String getLabel() {
        return this.searchDescription != null ? this.searchDescription : Messages.SearchHeaderName;
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        super.setInput(newSearch, viewState);
        if (newSearch != null) {
            this.searchDescription = newSearch.getLabel();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException("Doesn't support tree mode.");
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new TableViewer(parent, 66306);
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new ModelSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)ModelSearchResultPage.createTableLayout());
        TableViewerColumn colKind = new TableViewerColumn(viewer, 16384);
        colKind.getColumn().setText(ELEMENT_KIND_COLUMN);
        colKind.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String string;
                if (element instanceof IInterfaceElement) {
                    return "Pin";
                }
                if (element instanceof SearchResultTextMatch) {
                    SearchResultTextMatch textMatch = (SearchResultTextMatch)element;
                    string = textMatch.getElementKind();
                } else {
                    string = element.getClass().getSimpleName();
                }
                String kind = string;
                return kind.substring(0, kind.length() - 4);
            }
        });
        TableViewerColumn colName = new TableViewerColumn(viewer, 16384);
        colName.getColumn().setText(FordiacMessages.Name);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchResultTextMatch) {
                    SearchResultTextMatch textMatch = (SearchResultTextMatch)element;
                    return textMatch.getElementName();
                }
                if (element instanceof INamedElement) {
                    INamedElement ne = (INamedElement)element;
                    return ne.getName();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colComment = new TableViewerColumn(viewer, 16384);
        colComment.getColumn().setText(FordiacMessages.Comment);
        colComment.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchResultTextMatch) {
                    SearchResultTextMatch textMatch = (SearchResultTextMatch)element;
                    return textMatch.getElementComment();
                }
                if (element instanceof INamedElement) {
                    INamedElement ne = (INamedElement)element;
                    return ne.getComment();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colType = new TableViewerColumn(viewer, 16384);
        colType.getColumn().setText(FordiacMessages.Type);
        colType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                URI uri = ModelSearchResultPage.getUri(element);
                if (uri != null) {
                    return uri.lastSegment();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn path = new TableViewerColumn(viewer, 16384);
        path.getColumn().setText(PATH_COLUMN);
        path.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                List segments;
                URI uri = ModelSearchResultPage.getUri(element);
                if (uri != null && (segments = uri.segmentsList()).size() > 2) {
                    return segments.stream().skip(1L).limit(segments.size() - 2).map(URI::decode).collect(Collectors.joining("/"));
                }
                return super.getText(element);
            }
        });
        TableViewerColumn location = new TableViewerColumn(viewer, 16384);
        location.getColumn().setText(LOCATION_COLUMN);
        location.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TextMatch) {
                    TextMatch textMatch = (TextMatch)element;
                    return "Line: " + textMatch.getLine();
                }
                ModelSearchResult searchResult = ModelSearchResultPage.this.contentProvider.getSearchResult();
                return searchResult.getDictionary().hierarchicalName(element);
            }
        });
    }

    private static URI getUri(Object object) {
        if (object instanceof EObject) {
            EObject eObj = (EObject)object;
            return EcoreUtil.getURI((EObject)eObj);
        }
        if (object instanceof TextMatch) {
            TextMatch textMatch = (TextMatch)object;
            return textMatch.getUri();
        }
        return null;
    }

    private void jumpToBlock(OpenEvent doubleClick) {
        StructuredSelection selectionList = (StructuredSelection)doubleClick.getSelection();
        if (!selectionList.isEmpty()) {
            Object selection = selectionList.getFirstElement();
            if (selection instanceof TextMatch) {
                TextMatch textMatch = (TextMatch)selection;
                TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForURI(textMatch.getUri());
                IEditorPart editor = OpenListenerManager.openEditor((EObject)entry.getType());
                ModelSearchResultPage.showWithMarker(editor, entry.getFile(), textMatch);
            }
            if (selection instanceof EObject) {
                EObject eobj = (EObject)selection;
                this.jumpHelper(eobj);
            }
        }
    }

    private void jumpHelper(EObject jumpingTo) {
        IEditorPart editor = OpenListenerManager.openEditor((EObject)ModelSearchResultPage.getParent(jumpingTo));
        if (editor instanceof ISelectionListener) {
            ISelectionListener listener = (ISelectionListener)editor;
            if (jumpingTo instanceof Algorithm || jumpingTo instanceof Method || jumpingTo instanceof FunctionFBType) {
                IFile file = ModelHelper.getFileFromContextChecked((EObject)jumpingTo);
                Match[] matches = this.contentProvider.getSearchResult().getFordiacMatches(EcoreUtil.getURI((EObject)jumpingTo));
                Optional<TextMatch> firstMatch = Arrays.stream(matches).filter(TextMatch.class::isInstance).map(TextMatch.class::cast).findFirst();
                if (firstMatch.isPresent()) {
                    ModelSearchResultPage.showWithMarker(editor, file, firstMatch.get());
                }
            } else {
                listener.selectionChanged((IWorkbenchPart)editor, (ISelection)new StructuredSelection((Object)EcoreUtil.getURI((EObject)jumpingTo)));
            }
        } else {
            GraphicalViewer viewer = HandlerHelper.getViewer((IEditorPart)editor);
            HandlerHelper.selectElement((Object)jumpingTo, (GraphicalViewer)viewer);
        }
    }

    private static void showWithMarker(IEditorPart editor, IFile file, TextMatch match) {
        block12: {
            IMarker marker = null;
            try {
                try {
                    marker = file.createMarker(match.getType());
                    marker.setAttribute("charStart", match.getOffset());
                    marker.setAttribute("charEnd", match.getOffset() + match.getLength());
                    IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                }
                catch (CoreException coreException) {
                    if (marker == null) break block12;
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException2) {}
                }
            }
            finally {
                if (marker != null) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {}
                }
            }
        }
    }

    private static EObject getParent(EObject eobj) {
        SubApp subApp;
        if (eobj instanceof Device) {
            Device dev = (Device)eobj;
            return dev.getPosition().eContainer().eContainer();
        }
        if (eobj instanceof Application || eobj instanceof FBType) {
            return eobj;
        }
        BlockFBNetworkElement parent = null;
        if (eobj instanceof IInterfaceElement) {
            IInterfaceElement ie = (IInterfaceElement)eobj;
            parent = ie.getBlockFBNetworkElement();
            if (parent != null) {
                parent = parent.eContainer().eContainer();
            } else {
                parent = ie.eContainer();
                if (parent.eContainer() != null) {
                    parent = parent.eContainer();
                }
            }
        } else if (ModelSearchResultPage.isInternalFb(eobj)) {
            parent = eobj.eContainer();
        } else if (eobj instanceof Algorithm || eobj instanceof Method) {
            parent = eobj.eContainer();
        } else {
            if (eobj.eContainer() == null) {
                return eobj;
            }
            parent = eobj.eContainer().eContainer();
        }
        while (parent instanceof SubApp && (subApp = (SubApp)parent).isUnfolded()) {
            parent = subApp.eContainer().eContainer();
        }
        return parent;
    }

    private static boolean isInternalFb(EObject eobj) {
        FB fb;
        return eobj instanceof FB && (fb = (FB)eobj).eContainer() instanceof FBType && !fb.isContainedInTypedInstance();
    }

    protected static TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        return layout;
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void handleOpen(OpenEvent event) {
        this.jumpToBlock(event);
    }

    public static void showResult(EObject obj) {
        EObject toOpen = obj;
        if (obj instanceof IInterfaceElement) {
            IInterfaceElement ie = (IInterfaceElement)obj;
            toOpen = ie.getBlockFBNetworkElement();
        }
        if (obj instanceof SubApp) {
            toOpen = ((SubApp)toOpen).getOuterFBNetworkElement();
        }
        if (toOpen instanceof FBNetworkElement) {
            FBNetworkElement fbne = (FBNetworkElement)toOpen;
            IEditorPart p = HandlerHelper.openParentEditor((FBNetworkElement)fbne);
            HandlerHelper.selectElement((Object)obj, (IEditorPart)p);
        }
        HandlerHelper.openEditor((EObject)obj);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        ShowInEditorAction showInEditor = new ShowInEditorAction(this);
        mgr.prependToGroup("group.show", (IAction)showInEditor);
        super.fillContextMenu(mgr);
    }

    private static class ShowInEditorAction
    extends Action {
        private final ModelSearchResultPage fPage;

        public ShowInEditorAction(AbstractTextSearchViewPage page) {
            super("Show in Editor");
            this.setToolTipText("Shows element in the editor");
            this.fPage = (ModelSearchResultPage)page;
        }

        public void run() {
            ModelSearchResultPage.showResult((EObject)this.fPage.getViewer().getStructuredSelection().getFirstElement());
        }
    }
}

