/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui;

import java.text.MessageFormat;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class DeploymentLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), DeploymentLaunchShortcut.collectDeployableObjects(selection).collect(Collectors.toSet()), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPartSite site = editor.getSite();
        if (site != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            this.launch(this.getLaunchableResource(editor), DeploymentLaunchShortcut.collectDeployableObjects(selection).collect(Collectors.toSet()), mode);
            return;
        }
        this.launch(this.getLaunchableResource(editor), DeploymentLaunchShortcut.collectDeployableObjects(editor).collect(Collectors.toSet()), mode);
    }

    public void launch(IResource resource, Set<INamedElement> selection, String mode) {
        if (resource == null || selection.isEmpty()) {
            return;
        }
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.fordiac.ide.deployment.debug.deployLaunch");
            ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, resource.getName());
            this.initializeDefaultLaunchConfiguration(configuration, resource, selection, mode);
            configuration.launch(mode, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)MessageFormat.format(Messages.DeploymentLaunchShortcut_ErrorMessage, resource.getFullPath()), (IStatus)e.getStatus());
        }
    }

    public void initializeDefaultLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration, IResource resource, Set<INamedElement> selection, String mode) {
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.system", resource.getFullPath().toString());
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.selection", selection.stream().map(INamedElement::getQualifiedName).collect(Collectors.toSet()));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return DeploymentLaunchShortcut.getLaunchConfgurations(this.getLaunchableResource(selection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return DeploymentLaunchShortcut.getLaunchConfgurations(this.getLaunchableResource(editorpart));
    }

    protected static ILaunchConfiguration[] getLaunchConfgurations(IResource resource) {
        if (resource != null) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.fordiac.ide.deployment.debug.deployLaunch");
            try {
                return (ILaunchConfiguration[])Stream.of(manager.getLaunchConfigurations(type)).filter(configuration -> DeploymentLaunchShortcut.isRelevantLaunchConfiguration(configuration, resource)).toArray(ILaunchConfiguration[]::new);
            }
            catch (CoreException e) {
                FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
            }
        }
        return new ILaunchConfiguration[0];
    }

    protected static boolean isRelevantLaunchConfiguration(ILaunchConfiguration configuration, IResource resource) {
        try {
            return resource.equals((Object)DeploymentLaunchConfigurationAttributes.getSystemResource((ILaunchConfiguration)configuration));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
            return false;
        }
    }

    public IResource getLaunchableResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.stream().map(DeploymentLaunchShortcut::getLaunchableResource).flatMap(Optional::stream).findFirst().orElse(null);
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IEditorInput iEditorInput = editorpart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)iEditorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    protected static Optional<IResource> getLaunchableResource(Object element) {
        EObject object;
        EObject eObject;
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return Optional.of(resource);
        }
        if (element instanceof EObject && (eObject = EcoreUtil.getRootContainer((EObject)(object = (EObject)element))) instanceof AutomationSystem) {
            AutomationSystem system = (AutomationSystem)eObject;
            return Optional.ofNullable(system.getTypeEntry()).map(TypeEntry::getFile);
        }
        return Optional.empty();
    }

    protected static Stream<INamedElement> collectDeployableObjects(Object object) {
        if (object instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)object;
            return structuredSelection.stream().flatMap(DeploymentLaunchShortcut::collectDeployableObjects);
        }
        if (object instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)object;
            return DeploymentLaunchShortcut.collectDeployableObjects(editorPart.getEditorInput());
        }
        if (object instanceof IFileEditorInput) {
            IFileEditorInput editorInput = (IFileEditorInput)object;
            return DeploymentLaunchShortcut.collectDeployableObjects(editorInput.getFile());
        }
        if (object instanceof EditPart) {
            EditPart editPart = (EditPart)object;
            return DeploymentLaunchShortcut.collectDeployableObjects(editPart.getModel());
        }
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return DeploymentLaunchShortcut.collectDeployableObjects(TypeLibraryManager.INSTANCE.getTypeEntryForFile(file));
        }
        if (object instanceof SystemEntry) {
            SystemEntry systemEntry = (SystemEntry)object;
            return DeploymentLaunchShortcut.collectDeployableObjects(systemEntry.getSystem());
        }
        if (object instanceof AutomationSystem) {
            AutomationSystem automationSystem = (AutomationSystem)object;
            return DeploymentLaunchShortcut.collectDeployableObjects(automationSystem.getSystemConfiguration());
        }
        if (object instanceof SystemConfiguration) {
            SystemConfiguration systemConfiguration = (SystemConfiguration)object;
            return systemConfiguration.getDevices().stream().flatMap(DeploymentLaunchShortcut::collectDeployableObjects);
        }
        if (object instanceof Device) {
            Device device = (Device)object;
            return Stream.concat(Stream.of(device), device.getResource().stream().flatMap(DeploymentLaunchShortcut::collectDeployableObjects));
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return Stream.of(resource);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            return DeploymentLaunchShortcut.collectDeployableObjects(eObject.eContainer());
        }
        return Stream.empty();
    }
}

