/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.fordiac.ide.application.properties.StructManipulatorSection;
import org.eclipse.fordiac.ide.model.StructTreeLabelProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangePinVisibilityCommand;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;

public class MultiplexerSection
extends StructManipulatorSection {
    @Override
    protected ICheckStateListener getCheckStateListener() {
        return event -> {
            Command cmd = MultiplexerSection.createHideCommand(event.getElement(), event.getChecked());
            if (cmd != null && cmd.canExecute()) {
                this.executeCommand(cmd);
            } else {
                event.getCheckable().setChecked(event.getElement(), !event.getChecked());
            }
        };
    }

    private static Command createHideCommand(Object selected, boolean checked) {
        if (selected instanceof VarDeclaration) {
            VarDeclaration variable = (VarDeclaration)selected;
            return new ChangePinVisibilityCommand((IInterfaceElement)variable, checked);
        }
        return null;
    }

    @Override
    public void initTree(StructManipulator manipulator, TreeViewer viewer) {
    }

    @Override
    protected ICheckStateProvider getCheckStateProvider() {
        return new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement iel = (IInterfaceElement)element;
                    return iel.isVisible();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        };
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Multiplexer) {
                    Multiplexer mux = (Multiplexer)inputElement;
                    return mux.getInterface().getInputVars().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        };
    }

    @Override
    protected LabelProvider getLabelProvider() {
        return new StructTreeLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof MemberVarDeclaration) {
                    MemberVarDeclaration varDecl = (MemberVarDeclaration)element;
                    switch (columnIndex) {
                        case 0: {
                            return varDecl.getName();
                        }
                        case 1: {
                            return varDecl.getFullTypeName();
                        }
                        case 2: {
                            return varDecl.getComment();
                        }
                    }
                }
                return element.toString();
            }
        };
    }
}

