/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.marker.resolution;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class ChangeNameMarkerResolution
extends WorkbenchMarkerResolution {
    private final IMarker marker;

    protected ChangeNameMarkerResolution(IMarker marker) {
        this.marker = marker;
    }

    public void run(final IMarker marker) {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    ChangeNameMarkerResolution.this.runInWorkspace(marker);
                }
            }.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CoreException) {
                CoreException ce = (CoreException)throwable;
                ErrorDialog.openError(null, null, null, (IStatus)ce.getStatus());
            } else {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected abstract void runInWorkspace(IMarker var1) throws CoreException;

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Stream.of(markers).filter(other -> "org.eclipse.fordiac.ide.model.libraryElement".equals(FordiacErrorMarker.getSource((IMarker)other)) && this.isApplicable((IMarker)other)).toArray(IMarker[]::new);
    }

    protected boolean isApplicable(IMarker other) {
        return FordiacErrorMarker.getCode((IMarker)this.marker) == FordiacErrorMarker.getCode((IMarker)other) && Arrays.equals(FordiacErrorMarker.getData((IMarker)other), FordiacErrorMarker.getData((IMarker)this.marker));
    }

    protected static CoreException createExceptionForMarker(String pattern, IMarker marker) {
        return new CoreException(Status.error((String)MessageFormat.format(pattern, marker.getResource().getFullPath())));
    }
}

