/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.policies.AdapterNodeEditPolicy;
import org.eclipse.fordiac.ide.application.policies.EventNodeEditPolicy;
import org.eclipse.fordiac.ide.application.policies.VariableNodeEditPolicy;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.ui.IEditorPart;

public class InterfaceEditPartForFBNetwork
extends InterfaceEditPart {
    protected GraphicalNodeEditPolicy getNodeEditPolicy() {
        if (this.isEvent()) {
            return new EventNodeEditPolicy();
        }
        if (this.isAdapter()) {
            return new AdapterNodeEditPolicy();
        }
        if (this.isVariable()) {
            return new VariableNodeEditPolicy();
        }
        return null;
    }

    protected List<?> getModelSourceConnections() {
        ArrayList connections = new ArrayList(super.getModelSourceConnections());
        if (this.isUnfoldedSubapp()) {
            if (this.isInput()) {
                connections.addAll(this.getModel().getOutputConnections());
            }
            return connections;
        }
        return connections;
    }

    protected List<?> getModelTargetConnections() {
        ArrayList connections = new ArrayList(super.getModelTargetConnections());
        if (this.isUnfoldedSubapp()) {
            if (!this.isInput()) {
                connections.addAll(this.getModel().getInputConnections());
            }
            return connections;
        }
        return connections;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open" && this.canGoInto()) {
            this.goInto();
            return;
        }
        super.performRequest(request);
    }

    private boolean canGoInto() {
        BlockFBNetworkElement element = this.getModel().getBlockFBNetworkElement();
        return element instanceof SubApp || element instanceof CFBInstance;
    }

    protected void goInto() {
        SubApp subApp;
        BlockFBNetworkElement element = this.getModel().getBlockFBNetworkElement();
        IInterfaceElement selectionElement = this.getModel();
        if (element instanceof SubApp && InterfaceEditPartForFBNetwork.needsOppositeSubapp(subApp = (SubApp)element)) {
            element = element.getOpposite();
            selectionElement = element.getInterface().getInterfaceElement(selectionElement);
        }
        IEditorPart newEditor = OpenListenerManager.openEditor((EObject)element);
        GraphicalViewer viewer = (GraphicalViewer)newEditor.getAdapter(GraphicalViewer.class);
        HandlerHelper.selectElement((Object)selectionElement, (GraphicalViewer)viewer);
    }

    private static boolean needsOppositeSubapp(SubApp subapp) {
        return subapp.isMapped() && subapp.getMapping().getTo() == subapp;
    }

    protected boolean isUnfoldedSubapp() {
        SubApp subApp;
        BlockFBNetworkElement blockFBNetworkElement = this.getModel().getBlockFBNetworkElement();
        return blockFBNetworkElement instanceof SubApp && (subApp = (SubApp)blockFBNetworkElement).isUnfolded();
    }

    protected FixedAnchor createTargetConAnchor() {
        if (this.getModel() instanceof VarDeclaration && this.getModel().isIsInput()) {
            return new VarInputConnAnchor(this);
        }
        return super.createTargetConAnchor();
    }

    public static class VarInputConnAnchor
    extends FixedAnchor {
        private final InterfaceEditPartForFBNetwork ieEP;
        private IFigure valueFigure;

        public VarInputConnAnchor(InterfaceEditPartForFBNetwork ieEP) {
            super(ieEP.getFigure(), true);
            this.ieEP = ieEP;
        }

        public Point getLocation(Point reference) {
            IFigure fig;
            if (this.valueHasAnnotation() && (fig = this.getValueFigure()) != null) {
                Rectangle bounds = fig.getBounds().getCopy();
                fig.translateToAbsolute((Translatable)bounds);
                return bounds.getLeft();
            }
            return super.getLocation(reference);
        }

        private boolean valueHasAnnotation() {
            IFigure fig = this.getValueFigure();
            if (fig != null) {
                return fig.getBorder() instanceof GraphicalAnnotationStyles.AnnotationBorder;
            }
            return false;
        }

        private Value getValue() {
            return ((VarDeclaration)this.ieEP.getModel()).getValue();
        }

        IFigure getValueFigure() {
            EditPart ep;
            if (this.valueFigure == null && (ep = this.ieEP.getViewer().getEditPartForModel((Object)this.getValue())) instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)ep;
                this.valueFigure = graphicalEditPart.getFigure();
            }
            return this.valueFigure;
        }
    }
}

