/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.common.compaction.options.PolyominoOptions;
import org.eclipse.elk.alg.common.polyomino.PolyominoCompactor;
import org.eclipse.elk.alg.common.polyomino.structures.PlanarGrid;
import org.eclipse.elk.alg.common.polyomino.structures.Polyominoes;
import org.eclipse.elk.alg.disco.ICompactor;
import org.eclipse.elk.alg.disco.graph.DCComponent;
import org.eclipse.elk.alg.disco.graph.DCGraph;
import org.eclipse.elk.alg.disco.options.DisCoOptions;
import org.eclipse.elk.alg.disco.structures.DCPolyomino;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.Quadruple;

public class DisCoPolyominoCompactor
implements ICompactor {
    private double gridCellSizeX;
    private double gridCellSizeY;
    private final double upperBound = 100.0;
    private DCGraph cmpGraph;
    private List<DCPolyomino> polys;
    private PlanarGrid grid;
    private Double aspectRatio;
    private boolean fill;

    @Override
    public void compact(DCGraph graph) {
        double gridCellRecommendation;
        this.cmpGraph = graph;
        this.polys = Lists.newArrayList();
        this.gridCellSizeX = gridCellRecommendation = this.computeCellSize(this.cmpGraph);
        this.gridCellSizeY = gridCellRecommendation;
        this.fill = (Boolean)this.cmpGraph.getProperty(PolyominoOptions.POLYOMINO_FILL);
        this.aspectRatio = (Double)this.cmpGraph.getProperty(CoreOptions.ASPECT_RATIO);
        if (this.aspectRatio == null) {
            this.aspectRatio = 1.0;
        }
        if (this.aspectRatio > 1.0) {
            this.gridCellSizeX *= this.aspectRatio.doubleValue();
        } else {
            this.gridCellSizeY /= this.aspectRatio.doubleValue();
        }
        this.createPolyominoes();
        this.packPolyominoes();
        this.applyToDCGraph();
        this.cmpGraph.setProperty(DisCoOptions.DEBUG_DISCO_POLYS, this.polys);
    }

    private double computeCellSize(DCGraph graph) {
        double sumTerm = 0.0;
        double prodTerm = 0.0;
        Set<DCComponent> comps = graph.getComponents();
        int numOfComps = comps.size();
        for (DCComponent comp : comps) {
            KVector bounds = comp.getDimensionsOfBoundingRectangle();
            double width = bounds.x;
            double height = bounds.y;
            sumTerm += width + height;
            prodTerm += width * height;
        }
        double four = 4.0;
        double numerator = Math.sqrt(400.0 * (double)numOfComps * prodTerm - 4.0 * prodTerm + sumTerm * sumTerm) + sumTerm;
        double denominator = 2.0 * (100.0 * (double)numOfComps - 1.0);
        if (denominator == 0.0) {
            return numerator;
        }
        return numerator / denominator;
    }

    private void createPolyominoes() {
        Set<DCComponent> comps = this.cmpGraph.getComponents();
        for (DCComponent comp : comps) {
            DCPolyomino poly = new DCPolyomino(comp, this.gridCellSizeX, this.gridCellSizeY);
            this.polys.add(poly);
        }
    }

    private void packPolyominoes() {
        int id = 0;
        for (DCPolyomino poly : this.polys) {
            poly.setId(id);
            ++id;
        }
        Polyominoes polyHolder = new Polyominoes(this.polys, this.aspectRatio.doubleValue(), this.fill);
        new PolyominoCompactor().packPolyominoes(polyHolder);
        this.polys = polyHolder.getPolyominoes();
        this.grid = polyHolder.getGrid();
    }

    private void applyToDCGraph() {
        Quadruple gridCrop = this.grid.getFilledBounds();
        ElkPadding padding = (ElkPadding)this.cmpGraph.getProperty(DisCoOptions.PADDING);
        double paddingHori = padding.getHorizontal();
        double paddingVert = padding.getVertical();
        double parentWidth = (double)((Integer)gridCrop.getThird()).intValue() * this.gridCellSizeX + paddingHori;
        double parentHeight = (double)((Integer)gridCrop.getFourth()).intValue() * this.gridCellSizeY + paddingVert;
        this.cmpGraph.setDimensions(new KVector(parentWidth, parentHeight));
        for (DCPolyomino poly : this.polys) {
            int absoluteIntPositionX = poly.getX() - (Integer)gridCrop.getFirst();
            int absoluteIntPositionY = poly.getY() - (Integer)gridCrop.getSecond();
            KVector absolutePositionOnCanvas = new KVector((double)absoluteIntPositionX, (double)absoluteIntPositionY).scale(poly.getCellSizeX(), poly.getCellSizeY()).add(poly.getOffset());
            KVector originalCoordinates = poly.getRepresentee().getMinCorner();
            poly.getRepresentee().setOffset(absolutePositionOnCanvas.sub(originalCoordinates));
        }
    }
}

