/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.properties;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.properties.CommitPropertyDescriptor;
import org.eclipse.egit.ui.internal.properties.CommitPropertySource;
import org.eclipse.egit.ui.internal.properties.MessagePropertyDescriptor;
import org.eclipse.egit.ui.internal.properties.PersonIdentPropertySource;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class TagPropertySource
implements IPropertySource {
    private static final String PROPERTY_TAG_ID = "tag_id";
    private static final String PROPERTY_TAG_MESSAGE = "tag_message";
    private static final String PROPERTY_TAG_NAME = "tag_name";
    private static final String PROPERTY_TAG_TAGGER = "tag_tagger";
    private static final String PROPERTY_TAG_TARGET = "tag_target";
    private RevTag tag;
    private RevCommit commit;
    private Repository repository;
    private final String name;
    private final IPropertyDescriptor[] descriptors;
    private final PropertySheetPage page;

    public TagPropertySource(Repository repo, Ref ref, PropertySheetPage page) {
        this.repository = repo;
        this.page = page;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk refWalk = new RevWalk(repo);){
                ObjectId objectId = repo.resolve(ref.getName());
                RevObject any = refWalk.parseAny((AnyObjectId)objectId);
                if (any instanceof RevTag) {
                    this.tag = (RevTag)any;
                    refWalk.parseBody(this.tag.getObject());
                } else {
                    RevObject peeledObject = refWalk.peel(any);
                    if (peeledObject instanceof RevCommit) {
                        this.commit = (RevCommit)peeledObject;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        this.name = this.tag != null ? this.tag.getTagName() : Repository.shortenRefName((String)ref.getName());
        this.descriptors = this.createDescriptors();
    }

    public TagPropertySource(Repository repo, RevTag tag, PropertySheetPage page) {
        this.repository = repo;
        this.tag = tag;
        this.page = page;
        this.name = tag.getName();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk refWalk = new RevWalk(repo);){
                refWalk.parseBody(tag.getObject());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        this.descriptors = this.createDescriptors();
    }

    private IPropertyDescriptor[] createDescriptors() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        result.add(new PropertyDescriptor((Object)PROPERTY_TAG_NAME, UIText.TagPropertySource_TagName));
        if (this.tag == null) {
            if (this.commit != null) {
                result.add(new CommitPropertyDescriptor(PROPERTY_TAG_TARGET, UIText.TagPropertySource_TagTarget, new RepositoryCommit(this.repository, this.commit)));
            }
        } else {
            result.add(new PropertyDescriptor((Object)PROPERTY_TAG_ID, UIText.TagPropertySource_TagId));
            result.add(new MessagePropertyDescriptor(PROPERTY_TAG_MESSAGE, UIText.TagPropertySource_TagMessage, this.tag.getFullMessage(), this.page));
            result.add(new PropertyDescriptor((Object)PROPERTY_TAG_TAGGER, UIText.TagPropertySource_TagTagger));
            if (this.tag.getObject() instanceof RevCommit) {
                result.add(new CommitPropertyDescriptor(PROPERTY_TAG_TARGET, UIText.TagPropertySource_TagTarget, new RepositoryCommit(this.repository, (RevCommit)this.tag.getObject())));
            } else {
                result.add(new PropertyDescriptor((Object)PROPERTY_TAG_TARGET, UIText.TagPropertySource_TagTarget));
            }
        }
        for (PropertyDescriptor p : result) {
            p.setCategory(UIText.TagPropertySource_TagCategory);
        }
        return result.toArray(new IPropertyDescriptor[0]);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        switch (id.toString()) {
            case "tag_id": {
                return this.tag.name();
            }
            case "tag_name": {
                return this.name;
            }
            case "tag_target": {
                if (this.tag != null) {
                    RevObject target = this.tag.getObject();
                    if (target instanceof RevTag) {
                        return new TagPropertySource(this.repository, (RevTag)target, this.page);
                    }
                    if (target instanceof RevCommit) {
                        return new CommitPropertySource((RevCommit)target, this.page);
                    }
                    return Constants.typeString((int)target.getType()) + " " + target.name();
                }
                if (this.commit != null) {
                    return new CommitPropertySource(this.commit, this.page);
                }
                return null;
            }
            case "tag_tagger": {
                return new PersonIdentPropertySource(this.tag.getTaggerIdent());
            }
            case "tag_message": {
                return this.tag.getShortMessage();
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String toString() {
        return this.tag != null ? "tag " + this.tag.name() : MessageFormat.format(UIText.TagPropertySource_LightweightTag, this.name);
    }
}

